/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.compute;

public class XCorr {
    private final double[] fX;
    private final double[] fY;
    private double[] fValues;
    private boolean fValuesMissing;

    public XCorr(double[] pX, double[] pY) {
        this.fX = pX;
        this.fY = pY;
        if (this.fX.length != this.fY.length) {
            throw new IllegalArgumentException("XCorr : different size");
        }
        this.compute();
    }

    private void compute() {
        int n = this.fX.length;
        int troncature = n / 3;
        this.fValues = new double[troncature];
        double xMoy = XCorr.moyenne(this.fX);
        double yMoy = XCorr.moyenne(this.fY);
        double prodSigma = XCorr.ecartTypePearson(this.fX) * XCorr.ecartTypePearson(this.fY);
        for (int k = 0; k < troncature; ++k) {
            double somme = 0.0;
            int nb = 0;
            for (int i = 0; i < n - k; ++i) {
                if (Double.isNaN(this.fX[i]) || Double.isNaN(this.fY[i + k])) continue;
                somme += (this.fX[i] - xMoy) * (this.fY[i + k] - yMoy);
                ++nb;
            }
            if (nb != n - k) {
                this.fValuesMissing = true;
            }
            this.fValues[k] = somme / (double)nb / prodSigma;
        }
    }

    public boolean isValuesMissing() {
        return this.fValuesMissing;
    }

    public double[] getValues() {
        return this.fValues;
    }

    public static double ecartType(double[] pValues) {
        double moyenne = XCorr.moyenne(pValues);
        double sigma = 0.0;
        int nbValues = 0;
        for (double v : pValues) {
            if (Double.isNaN(v)) continue;
            double dif = v - moyenne;
            sigma += dif * dif;
            ++nbValues;
        }
        return Math.sqrt(sigma /= (double)(nbValues - 1));
    }

    public static double ecartTypePearson(double[] pValues) {
        double moyenne = XCorr.moyenne(pValues);
        double sigma = 0.0;
        int nbValues = 0;
        for (double v : pValues) {
            if (Double.isNaN(v)) continue;
            double dif = v - moyenne;
            sigma += dif * dif;
            ++nbValues;
        }
        return Math.sqrt(sigma /= (double)nbValues);
    }

    public static double moyenne(double[] pValues) {
        double somme = 0.0;
        int nbValues = 0;
        for (double v : pValues) {
            if (Double.isNaN(v)) continue;
            somme += v;
            ++nbValues;
        }
        return somme / (double)nbValues;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.fValues.length; ++i) {
            sb.append(i).append(" : ").append(this.fValues[i]);
        }
        return sb.toString();
    }
}

