/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.compute;

import fr.geonosis.karstmod.run.QNorm;
import java.util.Arrays;

public class SortedDischarge {
    private double[] fDischarges;
    private double[] fValues;
    private boolean fValuesMissing;

    public boolean isValuesMissing() {
        return this.fValuesMissing;
    }

    public SortedDischarge(double[] pDischarges) {
        int i;
        int nb;
        this.fDischarges = new double[pDischarges.length];
        double[] allDischarges = Arrays.copyOf(pDischarges, pDischarges.length);
        this.fValues = new double[0];
        if (pDischarges.length < 1) {
            return;
        }
        Arrays.sort(allDischarges);
        for (nb = allDischarges.length; nb > 0 && Double.isNaN(allDischarges[nb - 1]); --nb) {
        }
        if (nb <= 0) {
            return;
        }
        if (nb != allDischarges.length) {
            allDischarges = Arrays.copyOfRange(allDischarges, 0, nb);
            this.fValuesMissing = true;
        }
        double[] quant = new double[pDischarges.length];
        double current = allDischarges[0];
        int ix = 0;
        for (i = 1; i < allDischarges.length; ++i) {
            double d = allDischarges[i];
            if (current == d) continue;
            this.fDischarges[ix] = current;
            quant[ix] = (double)i / (double)nb;
            ++ix;
            current = d;
        }
        if (!Double.isNaN(current)) {
            this.fDischarges[ix] = current;
            quant[ix] = 1.0;
            ++ix;
        }
        if (ix > 1) {
            quant = Arrays.copyOfRange(quant, 0, ix);
            this.fDischarges = Arrays.copyOfRange(this.fDischarges, 0, ix);
            for (i = 0; i < quant.length; ++i) {
                quant[i] = (quant[i] + 1.0) / 2.0;
            }
            this.fValues = QNorm.compute(quant);
        }
    }

    public double value(int pIndex) {
        return this.fValues[pIndex];
    }

    public double discharge(int pIndex) {
        return this.fDischarges[pIndex];
    }

    public int size() {
        return this.fValues.length - 1;
    }
}

