/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.property;

import fr.dbe.util.property.ChangeEvent;
import fr.dbe.util.property.ChangeListener;
import fr.dbe.util.property.ReadOnlyProperty;
import java.util.HashSet;
import java.util.Set;

public class Property<T> {
    protected final Set<ChangeListener<T>> fListeners = new HashSet<ChangeListener<T>>();
    private final String fName;
    private T fValue;

    public Property(String pName) {
        this.fName = pName;
    }

    public T get() {
        return this.fValue;
    }

    public void set(T pValue) {
        if (this.fValue == null ? pValue == null : this.fValue.equals(pValue)) {
            return;
        }
        this.fValue = pValue;
        this.fireValueChanged(new ChangeEvent<T>(this.fName, pValue, this.fValue));
    }

    public void addChangeListener(ChangeListener<T> pListener) {
        if (pListener != null) {
            this.fListeners.add(pListener);
        }
    }

    public void removeChangeListener(ChangeListener<T> pListener) {
        this.fListeners.remove(pListener);
    }

    public void fireValueChanged(ChangeEvent<T> pEvent) {
        for (ChangeListener<T> p : this.fListeners) {
            p.valueChanged(pEvent);
        }
    }

    public ReadOnlyProperty<T> readOnlyProperty() {
        return new ReadOnlyProperty<T>(this.fValue);
    }
}

