/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.ihm.validation;

import fr.dbe.util.ihm.validation.InputValidator;
import fr.dbe.util.ihm.validation.ValidationResult;
import fr.dbe.util.ihm.validation.ValidationState;

public class IntegerValidator
implements InputValidator {
    private final int fMinValue;
    private final int fMaxValue;

    public IntegerValidator() {
        this.fMinValue = Integer.MIN_VALUE;
        this.fMaxValue = Integer.MAX_VALUE;
    }

    public IntegerValidator(int pMinValue) {
        this.fMinValue = pMinValue;
        this.fMaxValue = Integer.MAX_VALUE;
    }

    public IntegerValidator(int pMinValue, int pMaxValue) {
        this.fMinValue = pMinValue;
        this.fMaxValue = pMaxValue;
    }

    @Override
    public ValidationResult getValidationResult(String pValue) {
        try {
            int val = Integer.parseInt(pValue);
            if (val < this.fMinValue || val > this.fMaxValue) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException ex) {
            Object message = this.fMinValue == Integer.MIN_VALUE && this.fMaxValue == Integer.MAX_VALUE ? "doit contenir une valeur enti\u00e8re" : (this.fMinValue == Integer.MIN_VALUE ? "doit contenir une valeur enti\u00e8re inf\u00e9rieure ou \u00e9gale \u00e0 " + this.fMaxValue : (this.fMaxValue == Integer.MAX_VALUE ? "doit contenir une valeur enti\u00e8re sup\u00e9rieure ou \u00e9gale \u00e0 " + this.fMinValue : "doit contenir une valeur enti\u00e8re comprise entre " + this.fMinValue + " et " + this.fMaxValue + " inclus"));
            return new ValidationResult(ValidationState.ERROR, (String)message);
        }
        return new ValidationResult(ValidationState.OK);
    }
}

