/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.ihm.propertybox;

import fr.dbe.util.commun.Utilitaire;
import fr.dbe.util.ihm.Utils;
import fr.dbe.util.ihm.propertybox.PropertyListBoxListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class PropertyListBox<T>
extends Box {
    private final JList fList;
    private final JButton fBtAjouter;
    private final JButton fBtModifier;
    private final JButton fBtSupprimer;
    private final JButton fBtMonter;
    private final JButton fBtDescendre;
    private final PropertyListBoxListener<T> fListener;

    public PropertyListBox(PropertyListBoxListener<T> pListener) {
        super(0);
        this.fListener = pListener;
        this.fList = new JList(new DefaultListModel());
        this.fList.setFont(Utilitaire.FONT_DEFAUT);
        this.fBtAjouter = Utils.createButton("Ajouter", 110);
        this.fBtModifier = Utils.createButton("Modifier", 110);
        this.fBtSupprimer = Utils.createButton("Supprimer", 110);
        this.fBtMonter = Utils.createButton("Monter", 110);
        this.fBtDescendre = Utils.createButton("Descendre", 110);
        this.add(Utils.createVerticalBox(2, Utils.createLabel("Transformations : ")));
        this.add(new JScrollPane(this.fList));
        this.fList.setSelectionMode(1);
        this.add(Utils.createVerticalBox(1, this.fBtAjouter, this.fBtModifier, this.fBtSupprimer, this.fBtMonter, this.fBtDescendre));
        this.fBtAjouter.setEnabled(true);
        this.fBtModifier.setEnabled(false);
        this.fBtSupprimer.setEnabled(false);
        this.fBtMonter.setEnabled(false);
        this.fBtDescendre.setEnabled(false);
        this.fList.addListSelectionListener(pListSelectionEvent -> this.majEtat());
        this.fBtAjouter.addActionListener(pActionEvent -> {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    Object obj = PropertyListBox.this.fListener.ajouter();
                    if (obj != null) {
                        try {
                            ((DefaultListModel)PropertyListBox.this.fList.getModel()).addElement(obj);
                            PropertyListBox.this.fList.setSelectedValue(obj, true);
                            PropertyListBox.this.fListener.contentChanged();
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        });
        this.fBtModifier.addActionListener(pActionEvent -> {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    Object obj = PropertyListBox.this.fListener.modifier(PropertyListBox.this.fList.getSelectedValue());
                    if (obj != null) {
                        ((DefaultListModel)PropertyListBox.this.fList.getModel()).setElementAt(obj, PropertyListBox.this.fList.getSelectedIndex());
                        PropertyListBox.this.fList.setSelectedValue(obj, true);
                        PropertyListBox.this.fListener.contentChanged();
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        });
        this.fBtSupprimer.addActionListener(pActionEvent -> {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    DefaultListModel model = (DefaultListModel)PropertyListBox.this.fList.getModel();
                    for (Object obj : PropertyListBox.this.fList.getSelectedValuesList()) {
                        model.removeElement(obj);
                    }
                    PropertyListBox.this.fListener.contentChanged();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        });
        this.fBtMonter.addActionListener(pActionEvent -> {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    DefaultListModel model = (DefaultListModel)PropertyListBox.this.fList.getModel();
                    int[] indices = PropertyListBox.this.fList.getSelectedIndices();
                    Object pre = model.get(indices[0] - 1);
                    model.removeElement(pre);
                    model.insertElementAt(pre, indices[indices.length - 1]);
                    int i = 0;
                    while (i < indices.length) {
                        int n = i++;
                        indices[n] = indices[n] - 1;
                    }
                    PropertyListBox.this.fList.setSelectedIndices(indices);
                    PropertyListBox.this.fList.scrollRectToVisible(PropertyListBox.this.fList.getCellBounds(indices[0], indices[indices.length - 1]));
                    PropertyListBox.this.fListener.contentChanged();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        });
        this.fBtDescendre.addActionListener(pActionEvent -> {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    DefaultListModel model = (DefaultListModel)PropertyListBox.this.fList.getModel();
                    int[] indices = PropertyListBox.this.fList.getSelectedIndices();
                    Object sui = model.get(indices[indices.length - 1] + 1);
                    model.removeElement(sui);
                    model.insertElementAt(sui, indices[0]);
                    int i = 0;
                    while (i < indices.length) {
                        int n = i++;
                        indices[n] = indices[n] + 1;
                    }
                    PropertyListBox.this.fList.setSelectedIndices(indices);
                    PropertyListBox.this.fList.scrollRectToVisible(PropertyListBox.this.fList.getCellBounds(indices[0], indices[indices.length - 1]));
                    PropertyListBox.this.fListener.contentChanged();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        });
        this.fList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent pE) {
                if (pE.getClickCount() == 2 && PropertyListBox.this.fList.getSelectedIndices().length == 1 && PropertyListBox.this.fBtModifier.isEnabled()) {
                    PropertyListBox.this.fBtModifier.doClick();
                }
            }
        });
        this.fList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent pE) {
                switch (pE.getKeyCode()) {
                    case 8: 
                    case 127: {
                        if (!PropertyListBox.this.fBtSupprimer.isEnabled()) break;
                        PropertyListBox.this.fBtSupprimer.doClick();
                        break;
                    }
                    case 33: {
                        if (!PropertyListBox.this.fBtMonter.isEnabled()) break;
                        PropertyListBox.this.fBtMonter.doClick();
                        break;
                    }
                    case 34: {
                        if (!PropertyListBox.this.fBtDescendre.isEnabled()) break;
                        PropertyListBox.this.fBtDescendre.doClick();
                        break;
                    }
                    case 32: {
                        if (!PropertyListBox.this.fBtModifier.isEnabled()) break;
                        PropertyListBox.this.fBtModifier.doClick();
                    }
                }
            }
        });
    }

    protected void majEtat() {
        if (this.fList.getSelectedIndices().length > 0) {
            this.fBtSupprimer.setEnabled(true);
            this.fBtModifier.setEnabled(this.fList.getSelectedIndices().length == 1);
            this.fBtMonter.setEnabled(!this.fList.isSelectedIndex(0));
            this.fBtDescendre.setEnabled(!this.fList.isSelectedIndex(this.fList.getModel().getSize() - 1));
        } else {
            this.fBtModifier.setEnabled(false);
            this.fBtSupprimer.setEnabled(false);
            this.fBtMonter.setEnabled(false);
            this.fBtDescendre.setEnabled(false);
        }
    }

    public List<T> getElements() {
        ArrayList res = new ArrayList();
        DefaultListModel model = (DefaultListModel)this.fList.getModel();
        int nb = model.getSize();
        for (int i = 0; i < nb; ++i) {
            res.add(model.elementAt(i));
        }
        return res;
    }

    public void setElements(List<T> pElements) {
        DefaultListModel model = (DefaultListModel)this.fList.getModel();
        model.removeAllElements();
        if (pElements != null && !pElements.isEmpty()) {
            for (T t : pElements) {
                model.addElement(t);
            }
        }
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        super.setEnabled(pEnabled);
        if (pEnabled) {
            this.majEtat();
        } else {
            this.fList.setEnabled(false);
            this.fBtAjouter.setEnabled(false);
            this.fBtDescendre.setEnabled(false);
            this.fBtModifier.setEnabled(false);
            this.fBtMonter.setEnabled(false);
            this.fBtSupprimer.setEnabled(false);
        }
    }
}

