/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.ihm.propertybox;

import fr.dbe.util.commun.Utilitaire;
import fr.dbe.util.ihm.Utils;
import fr.dbe.util.ihm.propertybox.PropertyBox;
import fr.dbe.util.ihm.propertybox.PropertyBoxVide;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;

public class PropertyBoxCheckPopup<T>
extends PropertyBox<Set<T>> {
    private final JLabel fLib;
    private final JPopupMenu fPopup;
    private final int fMinSel;
    protected Map<T, JCheckBoxMenuItem> fMap;

    public PropertyBoxCheckPopup(String pLibelle, Set<T> pItems, int pMinSel) {
        this.fMinSel = pMinSel;
        this.fLib = new JLabel(pLibelle + " (0)", Utils.chargeIcone("bas.gif", PropertyBoxVide.class), 2);
        this.fLib.setFont(Utilitaire.FONT_DEFAUT);
        this.fLib.setHorizontalTextPosition(2);
        this.fMap = new HashMap<T, JCheckBoxMenuItem>();
        this.fPopup = new JPopupMenu();
        this.fLib.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent pE) {
                if (PropertyBoxCheckPopup.this.fMap.isEmpty()) {
                    return;
                }
                Point p = PropertyBoxCheckPopup.this.fLib.getLocation();
                p.translate(0, PropertyBoxCheckPopup.this.fLib.getHeight());
                PropertyBoxCheckPopup.this.fPopup.show(PropertyBoxCheckPopup.this.fLib, p.x, p.y);
            }
        });
        this.setItem(new HashSet());
        for (T elt : pItems) {
            this.ajoute(elt);
        }
        this.add(this.fLib);
    }

    @Override
    public void setItem(Set<T> pSet) {
        this.fItem = new HashSet();
        for (JCheckBoxMenuItem cb : this.fMap.values()) {
            cb.setSelected(false);
        }
        for (JCheckBoxMenuItem elt : pSet) {
            this.select(elt, true);
        }
        this.majItem();
        this.sort();
    }

    public JCheckBoxMenuItem ajoute(T pElt) {
        JCheckBoxMenuItem cb = new JCheckBoxMenuItem(pElt.toString());
        cb.setFont(this.fLib.getFont());
        cb.addItemListener(pItemEvent -> {
            if (cb.isSelected()) {
                ((Set)this.fItem).add(pElt);
            } else {
                ((Set)this.fItem).remove(pElt);
            }
            this.majItem();
        });
        this.fMap.put(pElt, cb);
        this.fPopup.add(cb);
        this.majItem();
        this.sort();
        return cb;
    }

    public void supprime(T pElt) {
        this.fPopup.remove(this.fMap.get(pElt));
        this.fMap.remove(pElt);
        ((Set)this.fItem).remove(pElt);
        this.majItem();
    }

    public void supprimeTout() {
        this.fPopup.removeAll();
        this.fMap.clear();
        ((Set)this.fItem).clear();
        this.majItem();
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        this.fLib.setEnabled(pEnabled);
    }

    @Override
    protected void majItem() {
        this.clearErreurMsg();
        if (((Set)this.fItem).size() < this.fMinSel) {
            this.setErreurMsg(this.fLib, "Un item au moins doit \u00eatre selectionn\u00e9");
        }
        this.fLib.setEnabled(!this.fMap.isEmpty());
        this.fLib.setText(this.fLib.getText().substring(0, this.fLib.getText().lastIndexOf(40)) + "(" + ((Set)this.fItem).size() + ")");
        this.fireStateChanged();
    }

    public void select(T pElt, boolean pSelected) {
        JCheckBoxMenuItem cb = this.fMap.get(pElt);
        if (cb != null) {
            cb.setSelected(pSelected);
            if (cb.isSelected()) {
                ((Set)this.fItem).add(pElt);
            } else {
                ((Set)this.fItem).remove(pElt);
            }
            this.majItem();
        }
    }

    public void sort() {
        List<MenuElement> l = Arrays.asList(this.fPopup.getSubElements());
        l.sort((pO1, pO2) -> ((JCheckBoxMenuItem)pO1.getComponent()).getText().compareTo(((JCheckBoxMenuItem)pO2).getText()));
        for (MenuElement m : l) {
            this.fPopup.add((JMenuItem)m);
        }
    }

    public int getElementCount() {
        return this.fMap.size();
    }
}

