/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.ihm.propertybox;

import fr.dbe.util.ihm.UpdateListener;
import fr.dbe.util.ihm.propertybox.JComboBoxPlusDetail;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;

public abstract class PropertyBox<T>
extends Box {
    private final List<JComponent> fErrComp = new ArrayList<JComponent>();
    private final List<ChangeListener> fListeners = new ArrayList<ChangeListener>();
    protected T fItem;
    protected String fErreurMsg;
    private ChangeListener fChangeListener;
    private UpdateListener fUpdateListener;
    private ItemListener fItemListener;
    private boolean fListenersActive = true;

    public PropertyBox() {
        super(1);
    }

    public PropertyBox(T pItem) {
        this();
        this.setItem(pItem);
    }

    public final T getItem() {
        return this.fItem;
    }

    public abstract void setItem(T var1);

    protected abstract void majItem();

    @Override
    public abstract void setEnabled(boolean var1);

    public void addChangeListener(ChangeListener pListener) {
        if (pListener != null) {
            this.fListeners.add(pListener);
        }
    }

    public void removeChangeListener(ChangeListener pListener) {
        if (pListener != null) {
            this.fListeners.remove(pListener);
        }
    }

    public void fireStateChanged() {
        Iterator<ChangeListener> it = this.fListeners.iterator();
        while (it.hasNext()) {
            it.next().stateChanged(null);
        }
    }

    public String getErreurMsg() {
        return this.fErreurMsg;
    }

    public void setErreurMsg(JComponent pComp, String pErreurMsg) {
        this.fErreurMsg = this.fErreurMsg == null ? pErreurMsg : this.fErreurMsg + "\n" + pErreurMsg;
        if (pComp != null) {
            pComp.setForeground(Color.RED);
            pComp.setToolTipText(pErreurMsg);
            this.fErrComp.add(pComp);
        }
    }

    public void clearErreurMsg() {
        this.fErreurMsg = null;
        for (JComponent comp : this.fErrComp) {
            comp.setForeground(Color.BLACK);
            comp.setToolTipText("");
        }
    }

    public boolean isOk() {
        return this.fErreurMsg == null;
    }

    public void addUpdateListenerFor(Component pComponent) {
        if (pComponent instanceof JTextField) {
            ((JTextField)pComponent).getDocument().addDocumentListener(this.getUpdateListener());
        } else if (pComponent instanceof JSpinner) {
            ((JSpinner)pComponent).addChangeListener(this.getChangeListener());
        } else if (pComponent instanceof JTextArea) {
            ((JTextArea)pComponent).getDocument().addDocumentListener(this.getUpdateListener());
        } else if (pComponent instanceof JRadioButton) {
            ((JRadioButton)pComponent).addItemListener(this.getItemListener());
        } else if (pComponent instanceof JComboBoxPlusDetail) {
            ((JComboBoxPlusDetail)pComponent).addItemListener(this.getItemListener());
        } else if (pComponent instanceof JCheckBox) {
            ((JCheckBox)pComponent).addItemListener(this.getItemListener());
        } else if (pComponent instanceof PropertyBox) {
            ((PropertyBox)pComponent).addChangeListener(this.getChangeListener());
        } else {
            throw new IllegalArgumentException(pComponent.getClass() + " NON PREVU");
        }
    }

    public UpdateListener getUpdateListener() {
        if (this.fUpdateListener == null) {
            this.fUpdateListener = new UpdateListener(){

                @Override
                public void textUpdated(DocumentEvent pE) {
                    if (!PropertyBox.this.fListenersActive) {
                        return;
                    }
                    PropertyBox.this.majItem();
                    PropertyBox.this.fireStateChanged();
                }
            };
        }
        return this.fUpdateListener;
    }

    public ChangeListener getChangeListener() {
        if (this.fChangeListener == null) {
            this.fChangeListener = pChangeEvent -> {
                if (!this.fListenersActive) {
                    return;
                }
                this.majItem();
                this.fireStateChanged();
            };
        }
        return this.fChangeListener;
    }

    public ItemListener getItemListener() {
        if (this.fItemListener == null) {
            this.fItemListener = pItemEvent -> {
                if (!this.fListenersActive) {
                    return;
                }
                this.majItem();
                this.fireStateChanged();
            };
        }
        return this.fItemListener;
    }

    protected void setListenersActive(boolean pListenersActive) {
        this.fListenersActive = pListenersActive;
    }

    public JComponent getErrComp() {
        return this.fErrComp.isEmpty() ? null : this.fErrComp.get(0);
    }
}

