/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.ihm.customdialog;

import fr.dbe.util.ihm.customdialog.CustomDialog;
import fr.dbe.util.ihm.customdialog.ObjectValidator;
import javax.swing.JOptionPane;

public class IntegerValidator
implements ObjectValidator<Integer> {
    private final int fMin;
    private final int fMax;

    public IntegerValidator(int pMin, int pMax) {
        this.fMin = pMin;
        this.fMax = pMax;
    }

    @Override
    public Integer validate(CustomDialog<Integer> pDialog, String pText) {
        Integer typedInt;
        try {
            typedInt = Integer.parseInt(pText);
            if (typedInt < this.fMin || typedInt > this.fMax) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(pDialog, "N must be an strictly positive integer.", "Error", 0);
            typedInt = null;
        }
        return typedInt;
    }
}

