/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.ihm;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableColumnAdjuster
implements PropertyChangeListener,
TableModelListener {
    private final JTable table;
    private final int spacing;
    private final Map<TableColumn, Integer> columnSizes = new HashMap<TableColumn, Integer>();
    private boolean isColumnHeaderIncluded;
    private boolean isColumnDataIncluded;
    private boolean isOnlyAdjustLarger;
    private boolean isDynamicAdjustment;

    public TableColumnAdjuster(JTable table) {
        this(table, 6);
    }

    public TableColumnAdjuster(JTable table, int spacing) {
        this.table = table;
        this.spacing = spacing;
        this.setColumnHeaderIncluded(true);
        this.setColumnDataIncluded(true);
        this.setOnlyAdjustLarger(true);
        this.setDynamicAdjustment(false);
    }

    public void adjustColumns() {
        TableColumnModel tcm = this.table.getColumnModel();
        int nbTasks = tcm.getColumnCount();
        if (nbTasks == 0) {
            return;
        }
        ExecutorService eservice = Executors.newFixedThreadPool(nbTasks);
        ExecutorCompletionService<Object> cservice = new ExecutorCompletionService<Object>(eservice);
        int[] width = new int[nbTasks];
        int i = 0;
        while (i < nbTasks) {
            int numCol = i++;
            cservice.submit(() -> {
                TableColumn tableColumn = this.table.getColumnModel().getColumn(numCol);
                if (!tableColumn.getResizable()) {
                    return null;
                }
                int columnHeaderWidth = this.getColumnHeaderWidth(numCol);
                int columnDataWidth = this.getColumnDataWidth(numCol);
                width[numCol] = Math.max(columnHeaderWidth, columnDataWidth);
                return null;
            });
        }
        for (i = 0; i < nbTasks; ++i) {
            try {
                cservice.take().get();
                continue;
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        eservice.shutdown();
        for (i = 0; i < nbTasks; ++i) {
            this.updateTableColumn(i, width[i]);
        }
    }

    public void adjustColumn(int column) {
        TableColumn tableColumn = this.table.getColumnModel().getColumn(column);
        if (!tableColumn.getResizable()) {
            return;
        }
        int columnHeaderWidth = this.getColumnHeaderWidth(column);
        int columnDataWidth = this.getColumnDataWidth(column);
        int preferredWidth = Math.max(columnHeaderWidth, columnDataWidth);
        this.updateTableColumn(column, preferredWidth);
    }

    private int getColumnHeaderWidth(int column) {
        if (!this.isColumnHeaderIncluded) {
            return 0;
        }
        TableColumn tableColumn = this.table.getColumnModel().getColumn(column);
        Object value = tableColumn.getHeaderValue();
        TableCellRenderer renderer = tableColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.table.getTableHeader().getDefaultRenderer();
        }
        Component c = renderer.getTableCellRendererComponent(this.table, value, false, false, -1, column);
        return c.getPreferredSize().width;
    }

    protected int getColumnDataWidth(int column) {
        if (!this.isColumnDataIncluded) {
            return 0;
        }
        int preferredWidth = 0;
        int maxWidth = this.table.getColumnModel().getColumn(column).getMaxWidth();
        for (int row = 0; row < this.table.getRowCount() && (preferredWidth = Math.max(preferredWidth, this.getCellDataWidth(row, column))) < maxWidth; ++row) {
        }
        return preferredWidth;
    }

    protected synchronized int getCellDataWidth(int row, int column) {
        TableCellRenderer cellRenderer = this.table.getCellRenderer(row, column);
        Component c = this.table.prepareRenderer(cellRenderer, row, column);
        return c.getPreferredSize().width + this.table.getIntercellSpacing().width;
    }

    private void updateTableColumn(int column, int width) {
        TableColumn tableColumn = this.table.getColumnModel().getColumn(column);
        if (!tableColumn.getResizable()) {
            return;
        }
        width += this.spacing;
        if (this.isOnlyAdjustLarger) {
            width = Math.max(width, tableColumn.getPreferredWidth());
        }
        this.columnSizes.put(tableColumn, tableColumn.getWidth());
        this.table.getTableHeader().setResizingColumn(tableColumn);
        tableColumn.setWidth(width);
    }

    public void restoreColumns() {
        TableColumnModel tcm = this.table.getColumnModel();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            this.restoreColumn(i);
        }
    }

    private void restoreColumn(int column) {
        TableColumn tableColumn = this.table.getColumnModel().getColumn(column);
        Integer width = this.columnSizes.get(tableColumn);
        if (width != null) {
            this.table.getTableHeader().setResizingColumn(tableColumn);
            tableColumn.setWidth(width);
        }
    }

    public void setColumnHeaderIncluded(boolean isColumnHeaderIncluded) {
        this.isColumnHeaderIncluded = isColumnHeaderIncluded;
    }

    public void setColumnDataIncluded(boolean isColumnDataIncluded) {
        this.isColumnDataIncluded = isColumnDataIncluded;
    }

    public void setOnlyAdjustLarger(boolean isOnlyAdjustLarger) {
        this.isOnlyAdjustLarger = isOnlyAdjustLarger;
    }

    public void setDynamicAdjustment(boolean isDynamicAdjustment) {
        if (this.isDynamicAdjustment != isDynamicAdjustment) {
            if (isDynamicAdjustment) {
                this.table.addPropertyChangeListener(this);
                this.table.getModel().addTableModelListener(this);
            } else {
                this.table.removePropertyChangeListener(this);
                this.table.getModel().removeTableModelListener(this);
            }
        }
        this.isDynamicAdjustment = isDynamicAdjustment;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("model".equals(e.getPropertyName())) {
            TableModel model = (TableModel)e.getOldValue();
            model.removeTableModelListener(this);
            model = (TableModel)e.getNewValue();
            model.addTableModelListener(this);
            this.adjustColumns();
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (!this.isColumnDataIncluded) {
            return;
        }
        if (e.getType() == 0) {
            int column = this.table.convertColumnIndexToView(e.getColumn());
            if (column >= 0) {
                if (this.isOnlyAdjustLarger) {
                    int row = e.getFirstRow();
                    TableColumn tableColumn = this.table.getColumnModel().getColumn(column);
                    if (tableColumn.getResizable()) {
                        int width = this.getCellDataWidth(row, column);
                        this.updateTableColumn(column, width);
                    }
                } else {
                    this.adjustColumn(column);
                }
            }
        } else {
            this.adjustColumns();
        }
    }

    private void installColumnAction(boolean isSelectedColumn, boolean isAdjust, String key, String keyStroke) {
        ColumnAction action = new ColumnAction(isSelectedColumn, isAdjust);
        KeyStroke ks = KeyStroke.getKeyStroke(keyStroke);
        this.table.getInputMap().put(ks, key);
        this.table.getActionMap().put(key, action);
    }

    private void installToggleAction(boolean isToggleDynamic, boolean isToggleLarger, String key, String keyStroke) {
        ToggleAction action = new ToggleAction(isToggleDynamic, isToggleLarger);
        KeyStroke ks = KeyStroke.getKeyStroke(keyStroke);
        this.table.getInputMap().put(ks, key);
        this.table.getActionMap().put(key, action);
    }

    public JTable getTable() {
        return this.table;
    }

    class ToggleAction
    extends AbstractAction {
        private final boolean isToggleDynamic;
        private final boolean isToggleLarger;

        public ToggleAction(boolean isToggleDynamic, boolean isToggleLarger) {
            this.isToggleDynamic = isToggleDynamic;
            this.isToggleLarger = isToggleLarger;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isToggleDynamic) {
                TableColumnAdjuster.this.setDynamicAdjustment(!TableColumnAdjuster.this.isDynamicAdjustment);
            } else if (this.isToggleLarger) {
                TableColumnAdjuster.this.setOnlyAdjustLarger(!TableColumnAdjuster.this.isOnlyAdjustLarger);
            }
        }
    }

    class ColumnAction
    extends AbstractAction {
        private final boolean isSelectedColumn;
        private final boolean isAdjust;

        public ColumnAction(boolean isSelectedColumn, boolean isAdjust) {
            this.isSelectedColumn = isSelectedColumn;
            this.isAdjust = isAdjust;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isSelectedColumn) {
                int[] columns = TableColumnAdjuster.this.table.getSelectedColumns();
                for (int i = 0; i < columns.length; ++i) {
                    if (this.isAdjust) {
                        TableColumnAdjuster.this.adjustColumn(columns[i]);
                        continue;
                    }
                    TableColumnAdjuster.this.restoreColumn(columns[i]);
                }
            } else if (this.isAdjust) {
                TableColumnAdjuster.this.adjustColumns();
            } else {
                TableColumnAdjuster.this.restoreColumns();
            }
        }
    }
}

