/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.ihm;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.RepaintManager;

public class PrintUtilities
implements Printable {
    private final Component fComponent;

    public PrintUtilities(Component pComponent) {
        this.fComponent = pComponent;
    }

    public static void printComponent(Component c) {
        new PrintUtilities(c).print();
    }

    public static void disableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(true);
    }

    public void print() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (PrinterException pe) {
                pe.printStackTrace();
            }
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) {
        if (pageIndex > 0) {
            return 1;
        }
        BufferedImage img = new BufferedImage(this.fComponent.getWidth(), this.fComponent.getHeight(), 2);
        Graphics grImg = img.getGraphics();
        this.fComponent.update(grImg);
        grImg.dispose();
        double scale = Math.min(pf.getImageableWidth() / (double)this.fComponent.getWidth(), pf.getImageableHeight() / (double)this.fComponent.getHeight());
        g.drawImage(img.getScaledInstance((int)((double)this.fComponent.getWidth() * scale), (int)((double)this.fComponent.getHeight() * scale), 4), (int)pf.getImageableX(), (int)pf.getImageableY(), null);
        return 0;
    }
}

