/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.ihm;

import fr.dbe.util.commun.Utilitaire;
import fr.dbe.util.ihm.Messages;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.util.StringTokenizer;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;

public class JTable2ExcelAdapter
implements ActionListener {
    private final JTable fTable;

    public JTable2ExcelAdapter(JTable pJTable) {
        this.fTable = pJTable;
    }

    public void enableCopy() {
        KeyStroke copy = Utilitaire.isMac() ? KeyStroke.getKeyStroke(67, 4, false) : KeyStroke.getKeyStroke(67, 2, false);
        this.fTable.registerKeyboardAction(this, Messages.getString("JTable2ExcelAdapter.0"), copy, 0);
    }

    public void enablePaste() {
        KeyStroke paste = Utilitaire.isMac() ? KeyStroke.getKeyStroke(86, 4, false) : KeyStroke.getKeyStroke(86, 2, false);
        this.fTable.registerKeyboardAction(this, Messages.getString("JTable2ExcelAdapter.1"), paste, 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().compareTo(Messages.getString("JTable2ExcelAdapter.2")) == 0) {
            StringBuilder sb = new StringBuilder();
            int numCols = this.fTable.getSelectedColumnCount();
            int numRows = this.fTable.getSelectedRowCount();
            int[] rowsSelected = this.fTable.getSelectedRows();
            int[] colsSelected = this.fTable.getSelectedColumns();
            for (int i = 0; i < numRows; ++i) {
                for (int j = 0; j < numCols; ++j) {
                    sb.append(this.fTable.getValueAt(rowsSelected[i], colsSelected[j]).toString().replaceAll("<[^>]*>", ""));
                    if (j >= numCols - 1) continue;
                    sb.append("\t");
                }
                sb.append("\n");
            }
            StringSelection selection = new StringSelection(sb.toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
        }
        if (e.getActionCommand().compareTo(Messages.getString("JTable2ExcelAdapter.3")) == 0) {
            int startRow = this.fTable.getSelectedRows()[0];
            int startCol = this.fTable.getSelectedColumns()[0];
            try {
                String trString;
                Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
                if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    trString = (String)t.getTransferData(DataFlavor.stringFlavor);
                } else if (t.isDataFlavorSupported(DataFlavor.getTextPlainUnicodeFlavor())) {
                    String line;
                    BufferedReader sr = new BufferedReader(DataFlavor.getTextPlainUnicodeFlavor().getReaderForText(t));
                    StringBuilder plainText = new StringBuilder();
                    while ((line = sr.readLine()) != null) {
                        plainText.append(line);
                    }
                    trString = plainText.toString();
                } else {
                    throw new Exception(Messages.getString("JTable2ExcelAdapter.4"));
                }
                trString = trString.replaceAll("\r\n", "\r");
                trString = trString.replaceAll("\n", "\r");
                StringTokenizer rowTokenizer = new StringTokenizer(trString, "\r");
                int row = startRow;
                while (rowTokenizer.hasMoreTokens()) {
                    String rowString = rowTokenizer.nextToken();
                    StringTokenizer colTokenizer = new StringTokenizer(rowString, "\t");
                    int col = startCol;
                    while (colTokenizer.hasMoreTokens()) {
                        String value = colTokenizer.nextToken();
                        if (row < this.fTable.getRowCount() && col < this.fTable.getColumnCount()) {
                            this.fTable.getModel().setValueAt(value, row, col);
                        }
                        ++col;
                    }
                    ++row;
                }
                ((DefaultTableModel)this.fTable.getModel()).fireTableStructureChanged();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

