/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.ihm;

import fr.dbe.util.commun.Utilitaire;
import fr.dbe.util.ihm.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class JProgressDialog
extends JDialog {
    final JProgressBar fProgressBar;
    final JLabel fLabel;

    public JProgressDialog(Frame pParent, String pTitle) {
        super(pParent, true);
        this.setTitle(pTitle);
        this.setDefaultCloseOperation(0);
        this.setAlwaysOnTop(true);
        this.setLocationRelativeTo(pParent);
        this.fProgressBar = new JProgressBar();
        this.fLabel = Utils.createLabel("");
        Box b = Box.createVerticalBox();
        b.add(Box.createVerticalStrut(20));
        b.add(this.fLabel);
        b.add(Box.createVerticalStrut(10));
        b.add(this.fProgressBar);
        this.fProgressBar.setFont(Utilitaire.FONT_DEFAUT);
        this.fProgressBar.setStringPainted(true);
        b.add(Box.createVerticalStrut(20));
        Box bb = Box.createHorizontalBox();
        bb.add(Box.createHorizontalStrut(20));
        bb.add(b);
        bb.add(Box.createHorizontalStrut(20));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)bb, "Center");
        this.setPreferredSize(new Dimension(400, 100));
        this.pack();
    }

    public void setText(String pText) {
        Runnable r = () -> this.fLabel.setText(pText);
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public void setIndeterminate(boolean pIndeterminate) {
        this.fProgressBar.setIndeterminate(pIndeterminate);
    }

    public void setProgress(int pValue) {
        Runnable r = () -> {
            this.fProgressBar.setValue(pValue);
            this.fProgressBar.setString(pValue + "%");
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }
}

