/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.ihm;

import fr.dbe.util.commun.Utilitaire;
import fr.dbe.util.ihm.ColorFont;
import fr.dbe.util.ihm.FontLabel;
import fr.dbe.util.ihm.InputList;
import fr.dbe.util.ihm.JButtonColor;
import fr.dbe.util.ihm.Messages;
import fr.dbe.util.ihm.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionListener;

public class JFontChooser
extends JDialog {
    private static final String PREVIEW_TEXT = "AaBbYyZz";
    public static String[] fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    public static String[] fontSizes = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
    protected int Closed_Option = -1;
    protected InputList fontNameInputList = new InputList(fontNames, Messages.getString("JFontChooser.0"));
    protected InputList fontSizeInputList = new InputList(fontSizes, Messages.getString("JFontChooser.1"));
    protected ColorFont fFont;
    protected JCheckBox boldCheckBox = new JCheckBox(Messages.getString("JFontChooser.2"));
    protected JCheckBox italicCheckBox = new JCheckBox(Messages.getString("JFontChooser.3"));
    protected JButtonColor fBtColor;
    protected FontLabel previewLabel;

    public JFontChooser(Frame owner) {
        super(owner, Messages.getString("JFontChooser.21"), false);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p = new JPanel(new GridLayout(1, 2, 10, 2));
        p.setBorder(new TitledBorder(new EtchedBorder(), Messages.getString("JFontChooser.22")));
        p.add(this.fontNameInputList);
        this.fontNameInputList.setDisplayedMnemonic('n');
        this.fontNameInputList.setToolTipText(Messages.getString("JFontChooser.23"));
        p.add(this.fontSizeInputList);
        this.fontSizeInputList.setDisplayedMnemonic('s');
        this.fontSizeInputList.setToolTipText(Messages.getString("JFontChooser.24"));
        this.getContentPane().add(p);
        p = new JPanel(new GridLayout(1, 3, 10, 5));
        p.setBorder(new TitledBorder(new EtchedBorder(), Messages.getString("JFontChooser.25")));
        this.boldCheckBox.setMnemonic('b');
        this.boldCheckBox.setToolTipText(Messages.getString("JFontChooser.26"));
        p.add(this.boldCheckBox);
        this.italicCheckBox.setMnemonic('i');
        this.italicCheckBox.setToolTipText(Messages.getString("JFontChooser.27"));
        p.add(this.italicCheckBox);
        Box b = Box.createHorizontalBox();
        JLabel lbl = new JLabel(Messages.getString("JFontChooser.28"));
        lbl.setDisplayedMnemonic('c');
        b.add(lbl);
        this.fBtColor = Utils.createButtonColor();
        lbl.setLabelFor(this.fBtColor);
        this.fBtColor.setToolTipText(Messages.getString("JFontChooser.29"));
        ToolTipManager.sharedInstance().registerComponent(this.fBtColor);
        b.add(this.fBtColor);
        b.add(Box.createHorizontalGlue());
        p.add(b);
        this.getContentPane().add(p);
        p = new JPanel(new BorderLayout());
        p.setBorder(new TitledBorder(new EtchedBorder(), Messages.getString("JFontChooser.30")));
        this.previewLabel = new FontLabel(PREVIEW_TEXT);
        p.add((Component)this.previewLabel, "Center");
        this.getContentPane().add(p);
        p = new JPanel(new FlowLayout());
        JPanel p1 = new JPanel(new GridLayout(1, 2, 10, 2));
        JButton btOK = new JButton("OK");
        btOK.setToolTipText(Messages.getString("JFontChooser.32"));
        this.getRootPane().setDefaultButton(btOK);
        ActionListener actionListener = pActionEvent -> {
            this.Closed_Option = 0;
            this.dispose();
        };
        btOK.addActionListener(actionListener);
        p1.add(btOK);
        JButton btCancel = new JButton(Messages.getString("JFontChooser.33"));
        btCancel.setToolTipText(Messages.getString("JFontChooser.34"));
        actionListener = pActionEvent -> {
            this.Closed_Option = 2;
            this.dispose();
        };
        btCancel.addActionListener(actionListener);
        p1.add(btCancel);
        p.add(p1);
        JButton btRestaurer = new JButton(Messages.getString("JFontChooser.35"));
        btRestaurer.setToolTipText(Messages.getString("JFontChooser.36"));
        actionListener = pActionEvent -> this.setFont(this.fFont);
        btRestaurer.addActionListener(actionListener);
        p1.add(btRestaurer);
        p.add(p1);
        this.getContentPane().add(p);
        this.pack();
        this.setResizable(false);
        ListSelectionListener listSelectListener = pListSelectionEvent -> this.updatePreview();
        this.fontNameInputList.addListSelectionListener(listSelectListener);
        this.fontSizeInputList.addListSelectionListener(listSelectListener);
        actionListener = pActionEvent -> this.updatePreview();
        this.boldCheckBox.addActionListener(actionListener);
        this.italicCheckBox.addActionListener(actionListener);
        this.fBtColor.addPropertyChangeListener(pPropertyChangeEvent -> {
            if (pPropertyChangeEvent.getPropertyName().equals("couleur")) {
                this.updatePreview();
            }
        });
    }

    public static ColorFont showDialog(Component pParent, String pTitre, ColorFont pFont) {
        JFontChooser dialog = new JFontChooser(Utils.getParentFrame(pParent));
        dialog.setTitle(pTitre);
        dialog.setFont(pFont == null ? new ColorFont(Utilitaire.FONT_PLAIN_10, Color.BLACK) : pFont);
        dialog.setModal(true);
        dialog.setVisible(true);
        ColorFont res = new ColorFont(dialog.previewLabel.getFont(), dialog.previewLabel.getForeground());
        dialog.dispose();
        return res;
    }

    public void setFont(ColorFont pFont) {
        this.fFont = pFont;
        this.fontNameInputList.setSelected(this.fFont.getFont().getName());
        this.fontSizeInputList.setSelectedInt(this.fFont.getFont().getSize());
        this.boldCheckBox.setSelected(this.fFont.getFont().isBold());
        this.italicCheckBox.setSelected(this.fFont.getFont().isItalic());
        this.fBtColor.setCouleur(this.fFont.getColor());
        this.updatePreview();
    }

    public int getOption() {
        return this.Closed_Option;
    }

    protected void updatePreview() {
        String name = this.fontNameInputList.getSelected();
        int size = this.fontSizeInputList.getSelectedInt();
        if (size <= 0) {
            return;
        }
        int style = 0;
        if (this.boldCheckBox.isSelected()) {
            style = this.italicCheckBox.isSelected() ? 3 : 1;
        } else if (this.italicCheckBox.isSelected()) {
            style = 2;
        }
        Font fn = new Font(name, style, size);
        this.previewLabel.setText(PREVIEW_TEXT);
        this.previewLabel.setFont(fn);
        Color c = this.fBtColor.getCouleur();
        this.previewLabel.setForeground(c);
        this.previewLabel.repaint();
    }
}

