/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.http;

import fr.dbe.util.http.HttpHeader;
import fr.dbe.util.http.HttpTransfertListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class HTTPHelper {
    private static final int BUF_SIZE = 8192;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void get(String pUrl, int pPort, File pFile, HttpTransfertListener pListener) throws IOException {
        Socket socket = null;
        int sepIndex = pUrl.indexOf("/");
        String host = pUrl.substring(0, sepIndex);
        String url = pUrl.substring(sepIndex);
        try {
            int nb;
            socket = new Socket(InetAddress.getByName(host), pPort);
            PrintWriter pw = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())), true);
            InputStream is = socket.getInputStream();
            pw.println("GET " + url + " HTTP/1.1\r\nHost: " + socket.getInetAddress().getHostName() + "\r\n");
            FileOutputStream os = new FileOutputStream(pFile);
            HttpHeader header = new HttpHeader();
            while (true) {
                String line;
                int car;
                StringBuilder sb = new StringBuilder();
                while ((car = is.read()) >= 0) {
                    sb.append((char)car);
                    if (!sb.toString().endsWith("\r\n")) continue;
                }
                if ((line = sb.substring(0, Math.max(0, sb.length() - 2))) == null || line.length() == 0) break;
                if (line.startsWith("HTTP/")) {
                    try {
                        header.setHttpVersion(line.split("/")[1].split(" ")[0]);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                if (line.startsWith("Date:")) {
                    try {
                        header.setDate(new SimpleDateFormat("EEE, dd MMM yyyy kk:mm:ss z", Locale.ENGLISH).parse(line.split(": ")[1]));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (line.startsWith("Server:")) {
                    header.setServer(line.split(": ")[1]);
                    continue;
                }
                if (line.startsWith("Last-Modified:")) {
                    try {
                        header.setLastModified(new SimpleDateFormat("EEE, dd MMM yyyy kk:mm:ss z", Locale.ENGLISH).parse(line.split(": ")[1]));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (line.startsWith("ETag:")) {
                    header.setETag(line.split(": ")[1]);
                    continue;
                }
                if (line.startsWith("Accept-Ranges:")) {
                    header.setAcceptRanges(line.split(": ")[1]);
                    continue;
                }
                if (line.startsWith("Content-Length:")) {
                    try {
                        header.setContentLength(Integer.parseInt(line.split(": ")[1]));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                if (!line.startsWith("Content-Type:")) continue;
                header.setContentType(line.split(": ")[1]);
            }
            if (pListener != null) {
                pListener.headerRed(header);
            }
            int nbTot = 0;
            byte[] buf = new byte[8192];
            while ((nb = is.read(buf)) >= 0) {
                nbTot += nb;
                if (pListener != null) {
                    pListener.bytesRed(nb, nbTot, header.getContentLength());
                }
                ((OutputStream)os).write(buf, 0, nb);
            }
            os.flush();
            ((OutputStream)os).close();
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }
}

