/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.commun;

import fr.dbe.util.commun.IPainter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class SplashWindow
extends Window {
    private static SplashWindow instance;
    private final JLabel fImageLabel;
    private IPainter fPainter;
    private boolean fPaintCalled = false;
    private JProgressBar fProgressBar = new JProgressBar();
    private JLabel fMessage;
    private int fMaxProgress;
    private int fWorked;

    private SplashWindow(Frame parent, ImageIcon pImage, boolean pProgressBar) {
        super(parent);
        this.setLayout(new BorderLayout());
        this.setBackground(new Color(255, 255, 255));
        this.fMaxProgress = 100;
        if (pProgressBar) {
            JPanel south = new JPanel(new BorderLayout());
            south.setBackground(Color.WHITE);
            this.fMessage = new JLabel(" ");
            south.add((Component)this.fMessage, "North");
            this.fProgressBar = new JProgressBar(0, 100);
            south.add((Component)this.fProgressBar, "South");
            this.add((Component)south, "South");
            this.validate();
            this.fProgressBar.setStringPainted(true);
            this.fProgressBar.setFont(new Font("Calibri", 0, 12));
            this.fMessage.setFont(new Font("Calibri", 0, 12));
            this.fMessage.setBackground(Color.WHITE);
            this.fMessage.setForeground(Color.BLACK);
            this.fMessage.setOpaque(false);
            this.pack();
        }
        this.fImageLabel = new JLabel(pImage);
        this.add((Component)this.fImageLabel, "Center");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public static void setMaxProgress(int pMaxProgress) {
        if (instance != null) {
            SplashWindow.instance.fMaxProgress = pMaxProgress;
            SplashWindow.instance.fWorked = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void splash(ImageIcon image, IPainter pPainter, boolean pProgressBar) {
        if (instance == null && image != null) {
            Frame f = new Frame();
            instance = new SplashWindow(f, image, pProgressBar);
            instance.setVisible(true);
            SplashWindow.instance.fPainter = pPainter;
            if (!EventQueue.isDispatchThread() && Runtime.getRuntime().availableProcessors() == 1) {
                SplashWindow splashWindow = instance;
                synchronized (splashWindow) {
                    while (!SplashWindow.instance.fPaintCalled) {
                        try {
                            instance.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
    }

    public static void disposeSplash() {
        if (instance != null) {
            instance.getOwner().dispose();
            instance = null;
        }
    }

    public static void invokeMain(String className, String[] args) {
        try {
            Class.forName(className).getMethod("main", String[].class).invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            throw new InternalError("Failed to invoke main method", e);
        }
    }

    public static void worked(int pWorked) {
        if (instance == null || SplashWindow.instance.fProgressBar == null) {
            return;
        }
        SplashWindow.instance.fWorked += pWorked;
        SwingUtilities.invokeLater(() -> SplashWindow.instance.fProgressBar.setValue(100 * SplashWindow.instance.fWorked / SplashWindow.instance.fMaxProgress));
    }

    public static void setMessage(String pMessage) {
        if (instance == null || SplashWindow.instance.fProgressBar == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            if (pMessage != null) {
                SplashWindow.instance.fMessage.setText(pMessage);
            }
        });
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        BufferedImage img = new BufferedImage(this.fImageLabel.getWidth(), this.fImageLabel.getHeight(), 2);
        Graphics2D gr = (Graphics2D)img.getGraphics();
        super.paint(gr);
        if (this.fPainter != null) {
            this.fPainter.paint(gr, this.fImageLabel.getWidth(), this.fImageLabel.getHeight());
        }
        g.drawImage(img, 0, 0, img.getWidth(), img.getHeight(), null);
        gr.dispose();
        if (!this.fPaintCalled) {
            this.fPaintCalled = true;
            SplashWindow splashWindow = this;
            synchronized (splashWindow) {
                this.notifyAll();
            }
        }
    }
}

