/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.commun;

public class Plage
implements Comparable<Plage> {
    private final int fIndiceMin;
    private final int fIndiceMax;

    public Plage(int pIndiceMin, int pIndiceMax) {
        this.fIndiceMin = pIndiceMin;
        this.fIndiceMax = pIndiceMax;
    }

    public int getIndiceMin() {
        return this.fIndiceMin;
    }

    public int getIndiceMax() {
        return this.fIndiceMax;
    }

    public int length() {
        return this.fIndiceMax - this.fIndiceMin + 1;
    }

    public String toString() {
        return "Plage [fIndiceMin=" + this.fIndiceMin + ", fIndiceMax=" + this.fIndiceMax + "]";
    }

    public boolean isEmpty() {
        return this.fIndiceMax - this.fIndiceMin < 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fIndiceMax;
        result = 31 * result + this.fIndiceMin;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Plage other = (Plage)obj;
        if (this.fIndiceMax != other.fIndiceMax) {
            return false;
        }
        return this.fIndiceMin == other.fIndiceMin;
    }

    public Plage union(Plage pPlage) {
        return new Plage(Math.min(this.fIndiceMin, pPlage.fIndiceMin), Math.max(this.fIndiceMax, pPlage.fIndiceMax));
    }

    public Plage intersection(Plage pPlage) {
        return new Plage(Math.max(this.fIndiceMin, pPlage.fIndiceMin), Math.min(this.fIndiceMax, pPlage.fIndiceMax));
    }

    @Override
    public int compareTo(Plage pPlage) {
        int res = this.fIndiceMin - pPlage.getIndiceMin();
        if (res == 0) {
            res = this.fIndiceMax - pPlage.getIndiceMax();
        }
        return res;
    }
}

