/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.commun;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IniFile {
    private final Map<String, Properties> fSections;

    public IniFile(String pFileName) throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(pFileName));){
            String line;
            this.fSections = new HashMap<String, Properties>();
            this.fSections.put("", new Properties());
            Properties currProps = null;
            while ((line = br.readLine()) != null) {
                int equalPos;
                String trimmedLine = line.trim();
                if (trimmedLine.length() == 0 || trimmedLine.startsWith("#") || trimmedLine.startsWith(";")) continue;
                if (line.startsWith("[")) {
                    if (!trimmedLine.endsWith("]")) {
                        currProps = null;
                        continue;
                    }
                    currProps = new Properties();
                    this.fSections.put(trimmedLine.substring(1, trimmedLine.length() - 1), currProps);
                    continue;
                }
                if (currProps == null) {
                    currProps = this.fSections.get("");
                }
                if ((equalPos = line.indexOf(61)) <= 0) continue;
                currProps.setProperty(line.substring(0, equalPos).trim(), line.substring(equalPos + 1).trim());
            }
        }
    }

    public String getProperty(String pSection, String pKey) {
        String res = this.fSections.get(pSection == null ? "" : pSection).getProperty(pKey);
        if (res == null) {
            return null;
        }
        if ((res = res.trim()).startsWith("\"")) {
            res = res.substring(1);
        }
        if (res.endsWith("\"")) {
            res = res.substring(0, res.length() - 1);
        }
        String patternString = "\\$\\{([^\\}]+)}";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(res);
        while (matcher.find()) {
            String key = matcher.group(0).replaceAll(patternString, "$1");
            String keyVal = this.getProperty(pSection, key);
            if (keyVal == null) {
                keyVal = "";
            }
            res = res.replaceFirst("\\$\\{" + key + "\\}", keyVal);
        }
        return res;
    }

    public boolean containsKey(String pSection, String pKey) {
        return this.fSections.get(pSection).containsKey(pKey);
    }
}

