/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.commun;

import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileSystemView;

public class FilePreview
extends JPanel
implements PropertyChangeListener {
    private final JLabel nom;
    private final JLabel taille;
    private final JLabel date;
    private final JLabel icone = new JLabel("Ic\u00f4ne du fichier");
    private final JLabel description;

    public FilePreview(JFileChooser pChooser) {
        super(new GridLayout(0, 1));
        this.add(this.icone);
        this.description = new JLabel("Description du fichier");
        this.add(this.description);
        this.nom = new JLabel("Nom du fichier");
        this.add(this.nom);
        this.taille = new JLabel("Taille du fichier");
        this.add(this.taille);
        this.date = new JLabel("Derni\u00e8re mod. du fichier");
        this.add(this.date);
        pChooser.addPropertyChangeListener(this);
        this.setBorder(new TitledBorder("Preview"));
    }

    public static void main(String[] args) {
        JFileChooser chooser = new JFileChooser(".");
        chooser.setAccessory(new FilePreview(chooser));
        chooser.showOpenDialog(null);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if ("SelectedFileChangedProperty".equals(prop)) {
            File file = (File)e.getNewValue();
            if (file == null) {
                this.clear();
                return;
            }
            FileSystemView vueSysteme = FileSystemView.getFileSystemView();
            Locale locale = Locale.getDefault();
            NumberFormat nf = NumberFormat.getInstance(locale);
            DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
            this.icone.setIcon(vueSysteme.getSystemIcon(file));
            this.nom.setText(vueSysteme.getSystemDisplayName(file));
            this.description.setText(vueSysteme.getSystemTypeDescription(file));
            String tailleFile = nf.format((double)file.length() / 1024.0) + " Kb";
            this.taille.setText(tailleFile);
            String dateFile = dateFormat.format(new Date(file.lastModified()));
            this.date.setText("Derni\u00e8re mod : " + dateFile);
        } else {
            this.clear();
        }
    }

    private void clear() {
        this.icone.setIcon(null);
        this.nom.setText("Nom du fichier");
        this.description.setText("Description fichier");
        this.taille.setText("Taille du fichier");
        this.date.setText("Derni\u00e8re mod. du fichier");
    }
}

