/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.commun;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;

public class ClassLoaderPerso
extends ClassLoader {
    private static ClassLoaderPerso instance;
    private final Hashtable<String, Class<?>> fClasses = new Hashtable();

    private ClassLoaderPerso() {
        super(ClassLoaderPerso.class.getClassLoader());
    }

    public static synchronized ClassLoaderPerso getInstance() {
        if (instance == null) {
            instance = new ClassLoaderPerso();
        }
        return instance;
    }

    @Override
    public Class<?> loadClass(String pNomClasse) {
        return this.findClass(pNomClasse);
    }

    @Override
    public Class<?> findClass(String pNomClasse) {
        Class<?> classe = this.fClasses.get(pNomClasse);
        if (classe != null) {
            return classe;
        }
        try {
            return this.findSystemClass(pNomClasse);
        }
        catch (Exception exception) {
            try {
                URL url = ClassLoader.getSystemResource(pNomClasse.replace('.', File.separatorChar));
                if (url != null) {
                    String chemin = (url.getFile() + ".class").substring(1);
                    byte[] buffer = this.getBytes(chemin);
                    classe = this.defineClass(pNomClasse, buffer, 0, buffer.length, null);
                    this.fClasses.put(pNomClasse, classe);
                    return classe;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                String chemin = pNomClasse.replace('.', File.separatorChar) + ".class";
                byte[] buffer = this.getBytes(chemin);
                classe = this.defineClass(pNomClasse, buffer, 0, buffer.length, null);
                this.fClasses.put(pNomClasse, classe);
                return classe;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    @Override
    public Class<?> findClass(String pNomClasse, String dir) {
        try {
            String chemin = dir + "/" + pNomClasse.replace('.', File.separatorChar) + ".class";
            byte[] buffer = this.getBytes(chemin);
            Class<?> classe = this.defineClass(pNomClasse, buffer, 0, buffer.length, null);
            this.fClasses.put(pNomClasse, classe);
            return classe;
        }
        catch (Exception e) {
            return null;
        }
    }

    private byte[] getBytes(String pNomClasse) throws IOException {
        File f = new File(pNomClasse);
        int taille = (int)f.length();
        byte[] buff = new byte[taille];
        FileInputStream fis = new FileInputStream(f);
        DataInputStream dis = new DataInputStream(fis);
        dis.readFully(buff);
        dis.close();
        return buff;
    }
}

