/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Fond;
import fr.dbe.graphique.JDessinGraphique;
import fr.dbe.graphique.Radar;
import fr.dbe.graphique.Repere;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class ToileRadar
extends Fond {
    private final String[] fLabels;
    private final double fStartAngle;
    private final double fYMin;
    private final double fYMax;
    private final double minAxis;
    private final double tic;
    private double fCenterX;
    private double fCenterY;
    private double fDr;
    private Radar.Axis[] fAxis;

    public ToileRadar(String pNom, String[] pLabels, double pStartAngle, double pMin, double pMax, double pMinAxis, double pTic) {
        super(pNom);
        this.fLabels = pLabels;
        this.fStartAngle = pStartAngle;
        this.fYMin = pMin;
        this.fYMax = pMax;
        this.minAxis = pMinAxis;
        this.tic = pTic;
        this.setVisibleInMenu(false);
    }

    @Override
    public void dessine(Graphics pGraphic, Repere pRepere) {
        JDessinGraphique dessin = pRepere.getDessin();
        Graphics2D gr = (Graphics2D)pGraphic;
        gr.setFont(pRepere.getAxeH().getGraduation().getPolice());
        double alpha = Math.PI * 2 / (double)this.fLabels.length;
        int padding = 5;
        double x0 = (int)dessin.getMargesAxe().getGauche() + padding;
        double y0 = (int)dessin.getMargesAxe().getHaut() + padding;
        double w = -2 * padding + dessin.getWidth() - (int)(dessin.getMargesAxe().getGauche() + dessin.getMargesAxe().getDroite());
        double h = -2 * padding + dessin.getHeight() - (int)(dessin.getMargesAxe().getHaut() + dessin.getMargesAxe().getBas());
        this.fCenterX = x0 + w / 2.0;
        this.fCenterY = y0 + h / 2.0;
        gr.setColor(Color.RED);
        gr.setStroke(new BasicStroke(1.0f));
        FontMetrics fm = gr.getFontMetrics();
        double rMax = Math.min(h / 2.0, w / 2.0);
        this.fAxis = new Radar.Axis[this.fLabels.length];
        for (int i = 0; i < this.fLabels.length; ++i) {
            double a = this.fStartAngle + (double)i * alpha - 1.5707963267948966;
            double dx = Math.cos(a);
            double dy = Math.sin(a);
            double ddx = w / 2.0 / dx;
            double ddy = h / 2.0 / dy;
            double dd = Math.min(Math.abs(ddx), Math.abs(ddy));
            double x = x0 + w / 2.0 + dd * dx;
            double y = y0 + h / 2.0 + dd * dy;
            String s = this.fLabels[i];
            Rectangle textBounds = fm.getStringBounds(s, gr).getBounds();
            double xLabel = x - textBounds.getWidth() / 2.0;
            double yLabel = y + (double)(fm.getAscent() / 2);
            Rectangle rect = new Rectangle((int)xLabel, (int)yLabel - fm.getAscent(), (int)textBounds.getWidth(), fm.getAscent() + fm.getDescent());
            double dxLabel = 0.0;
            double dyLabel = 0.0;
            if ((double)rect.x < x0) {
                dxLabel = x0 - (double)rect.x;
            } else if ((double)(rect.x + rect.width) > x0 + w) {
                dxLabel = x0 + w - (double)(rect.x + rect.width);
            }
            if ((double)rect.y < y0) {
                dyLabel = y0 - (double)rect.y;
            } else if ((double)(rect.y + rect.height) > y0 + h) {
                dyLabel = y0 + h - (double)(rect.y + rect.height);
            }
            if (Math.abs(dxLabel / dx) > Math.abs(dyLabel / dy)) {
                dyLabel = (int)(dxLabel / dx * dy);
            } else {
                dxLabel = (int)(dyLabel / dy * dx);
            }
            rect.x = (int)((double)rect.x + dxLabel);
            rect.y = (int)((double)rect.y + dyLabel);
            this.fAxis[i] = new Radar.Axis(a, dx, dy, s, rect);
            for (int[] c : new int[][]{{rect.x, rect.y}, {rect.x + rect.width, rect.y}, {rect.x + rect.width, rect.y + rect.height}, {rect.x, rect.y + rect.height}}) {
                double d = Math.pow((double)c[0] - this.fCenterX, 2.0) + Math.pow((double)c[1] - this.fCenterY, 2.0);
                if (!(d < rMax * rMax)) continue;
                rMax = (int)Math.sqrt(d);
            }
        }
        this.fDr = rMax / (this.fYMax - this.fYMin);
        for (Radar.Axis ax : this.fAxis) {
            double x = this.fCenterX + (double)((int)(ax.dx * rMax));
            double y = this.fCenterY + (double)((int)(ax.dy * rMax));
            gr.setColor(pRepere.getAxeH().getCouleur());
            gr.drawLine((int)this.fCenterX, (int)this.fCenterY, (int)x, (int)y);
            gr.setColor(pRepere.getAxeH().getCouleurEtiquette());
            gr.drawString(ax.label, (int)Math.min(x0 + w - (double)ax.labelRect.width, Math.max(x0, x - (double)(ax.labelRect.width / 2) + ax.dx * 20.0)), (int)Math.max(y0, Math.min(y0 + h, y + (double)(fm.getAscent() / 2) + ax.dy * 20.0)));
            double d = pRepere.getAxeH().getMax();
        }
        gr.setColor(dessin.getChartBackgroundColor());
        int rMinAxis = (int)(this.fDr * this.minAxis);
        gr.fillOval((int)this.fCenterX - rMinAxis, (int)this.fCenterY - rMinAxis, 2 * rMinAxis, 2 * rMinAxis);
        gr.setColor(pRepere.getQuadrillageH().getCouleur());
        for (double q = this.minAxis; q <= this.fYMax; q += this.tic) {
            for (int i = 0; i < this.fLabels.length; ++i) {
                gr.drawLine((int)(this.fCenterX + this.fAxis[i].dx * this.fDr * q), (int)(this.fCenterY + this.fAxis[i].dy * this.fDr * q), (int)(this.fCenterX + this.fAxis[(i + 1) % this.fLabels.length].dx * this.fDr * q), (int)(this.fCenterY + this.fAxis[(i + 1) % this.fLabels.length].dy * this.fDr * q));
            }
            String le = String.format("%.1f", q);
            Rectangle re = fm.getStringBounds(le, gr).getBounds();
            gr.setColor(dessin.getChartBackgroundColor());
            gr.fillRect((int)(this.fCenterX - (double)(re.width / 2)) - 1, (int)(this.fCenterY - this.fDr * q * Math.cos(this.fStartAngle)) - 1 - fm.getAscent() / 2, re.width + 2, re.height + 2);
            gr.setColor(pRepere.getQuadrillageH().getCouleur());
            gr.drawString(le, (int)this.fCenterX - re.width / 2, (int)(this.fCenterY + (double)(fm.getAscent() / 2) - this.fDr * q * Math.cos(this.fStartAngle)));
        }
    }

    @Override
    public void dessineLegende(Graphics2D pGraphics2d, int pWidth, int pHeight) {
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public void setVisible(boolean pSelected) {
    }

    @Override
    public double getYMin() {
        return this.fYMin;
    }

    @Override
    public double getYMax() {
        return this.fYMax;
    }

    public double getCenterX() {
        return this.fCenterX;
    }

    public double getCenterY() {
        return this.fCenterY;
    }

    public double getDr() {
        return this.fDr;
    }

    public Radar.Axis[] getAxis() {
        return this.fAxis;
    }
}

