/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.JDessinGraphique;
import fr.dbe.graphique.JProprietesGraphique;
import fr.dbe.graphique.LegendeWidget;
import fr.dbe.util.ihm.HorizontalLabelPosition;
import fr.dbe.util.ihm.SharedFrame;
import fr.dbe.util.ihm.Utils;
import fr.dbe.util.ihm.VerticalLabelPosition;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class TitleWidget
extends LegendeWidget {
    private GroupLayout.Alignment fAlignment;

    public TitleWidget(JDessinGraphique pDessin) {
        super(pDessin);
        this.fDxGauche = Integer.MIN_VALUE;
        this.setCadre(false);
        this.setFont(new Font("Arial", 1, 16));
        this.fAlignment = GroupLayout.Alignment.CENTER;
    }

    public void setAlignment(GroupLayout.Alignment pAlignment) {
        this.fAlignment = pAlignment;
    }

    @Override
    public void dessine(Graphics pGraphics) {
        Graphics2D g = (Graphics2D)pGraphics;
        String title = this.getDessin().getTitle();
        if (this.isVisible() && title != null && title.length() > 0) {
            g.setFont(this.getFont());
            FontMetrics fm = g.getFontMetrics();
            int w = fm.stringWidth(title);
            if (this.fDxGauche == Integer.MIN_VALUE) {
                switch (this.fAlignment) {
                    case CENTER: {
                        this.fDxGauche = (this.getDessin().getWidth() - w) / 2;
                        break;
                    }
                    case LEADING: {
                        this.fDxGauche = this.getDessin().getWidth() - w - 10;
                        break;
                    }
                    case TRAILING: {
                        this.fDxGauche = 20;
                    }
                }
            }
            int xLegende = Math.max(0, this.getDessin().getWidth() - w - this.fDxGauche);
            this.fDxGauche = this.getDessin().getWidth() - w - xLegende;
            int x = xLegende;
            int y = this.fPosY;
            if (this.getCouleurTexte() != null) {
                g.setColor(this.getCouleurTexte());
            }
            Color bg = null;
            if (this.getCouleurFond() != null) {
                bg = new Color(this.getCouleurFond().getRed(), this.getCouleurFond().getGreen(), this.getCouleurFond().getBlue(), (int)(this.getTransparence() * 255.0f));
            }
            Border border = null;
            if (this.isCadre() && this.getCouleurCadre() != null) {
                border = BorderFactory.createLineBorder(this.getCouleurCadre());
            }
            this.getRectangle().setBounds(Utils.drawLibelleHtml(g, x, y, title, HorizontalLabelPosition.LEFT, VerticalLabelPosition.TOP, bg, border));
            if (this.isSelected()) {
                x = this.getRectangle().x;
                y = this.getRectangle().y;
                w = this.getRectangle().width;
                int h = this.getRectangle().height;
                g.setColor(Color.DARK_GRAY);
                g.fillRect(x - 2, y - 2, 4, 4);
                g.fillRect(x - 2, y - 2 + h, 4, 4);
                g.fillRect(x - 2 + w, y - 2, 4, 4);
                g.fillRect(x - 2 + w, y - 2 + h, 4, 4);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent pE) {
        if (pE.getClickCount() != 1) {
            SharedFrame f = new SharedFrame();
            SwingUtilities.invokeLater(() -> {
                JProprietesGraphique d = new JProprietesGraphique((Component)f, this.getDessin());
                d.selectAffichage();
                d.setLocationRelativeTo(pE.getComponent());
                d.setVisible(true);
                f.dispose();
                pE.getComponent().repaint();
            });
        }
    }
}

