/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Activable;
import fr.dbe.graphique.ConfigPlage;
import fr.dbe.graphique.MapXmlGraph;
import fr.dbe.graphique.Messages;
import fr.dbe.graphique.PointGraphique;
import fr.dbe.graphique.Repere;
import fr.dbe.graphique.SerieListener;
import fr.dbe.util.commun.Bornes;
import fr.dbe.util.commun.Plage;
import fr.dbe.util.xml.IXmlElement;
import fr.dbe.util.xml.XmlUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class Serie
implements IXmlElement,
Activable {
    public static final String DOM_NOM = "nom";
    private static final String DOM_VISIBLE = "visible";
    private final List<SerieListener> listeners = new ArrayList<SerieListener>();
    protected Color fCouleur;
    protected String fNom;
    protected Repere fRepere;
    protected double xMin = Double.POSITIVE_INFINITY;
    protected double xMax = Double.NEGATIVE_INFINITY;
    protected double yMin = Double.POSITIVE_INFINITY;
    protected double yMax = Double.NEGATIVE_INFINITY;
    private boolean fVisible = true;
    private boolean fVisibleInMenu = true;
    private ConfigPlage fConfigPlage;
    private boolean fCursorable;
    private boolean fActive = true;
    private String fOutputLabel;
    private boolean fHighlighted;

    public Serie(String nom) {
        this.fNom = nom;
        this.fCouleur = Color.black;
        this.fCursorable = true;
    }

    public void razMinMax() {
        this.xMin = Double.POSITIVE_INFINITY;
        this.xMax = Double.NEGATIVE_INFINITY;
        this.yMin = Double.POSITIVE_INFINITY;
        this.yMax = Double.NEGATIVE_INFINITY;
    }

    public void majMinMax(double x, double y) {
        this.xMin = Math.min(x, this.xMin);
        this.xMax = Math.max(x, this.xMax);
        this.yMin = Math.min(Double.isNaN(y) ? this.yMin : y, this.yMin);
        this.yMax = Math.max(Double.isNaN(y) ? this.yMax : y, this.yMax);
    }

    public void majMinMax() {
        for (int i = this.size() - 1; i >= 0; --i) {
            this.majMinMax(this.getX(i), this.getY(i));
        }
    }

    public void majMinMaxY() {
        this.yMin = Double.POSITIVE_INFINITY;
        this.yMax = Double.NEGATIVE_INFINITY;
        for (int i = this.size() - 1; i >= 0; --i) {
            double y = this.getY(i);
            this.yMin = Math.min(Double.isNaN(y) ? this.yMin : y, this.yMin);
            this.yMax = Math.max(Double.isNaN(y) ? this.yMax : y, this.yMax);
        }
    }

    public double getXMin() {
        return this.xMin;
    }

    public double getXMax() {
        return this.xMax;
    }

    public double getYMin() {
        return this.yMin;
    }

    public double getYMax() {
        return this.yMax;
    }

    public abstract Bornes bornesY(double var1, double var3);

    public abstract double getX(int var1);

    public abstract double getY(int var1);

    public final Color getCouleur() {
        return this.fCouleur;
    }

    public void setCouleur(Color c) {
        this.fCouleur = c;
        this.fireColorChanged();
    }

    public abstract int size();

    public String getNom() {
        return this.fNom;
    }

    public void setNom(String nom) {
        this.fNom = nom;
        this.fireSerieRenamed();
    }

    public abstract void dessine(Graphics var1, double var2, double var4, int var6);

    public String toString() {
        return this.fNom;
    }

    public String save(String pNomFic) {
        try {
            if (!((String)pNomFic).toLowerCase().endsWith(".txt")) {
                pNomFic = (String)pNomFic + ".txt";
            }
            StringWriter sw = new StringWriter(10000);
            PrintWriter pw = new PrintWriter(sw);
            pw.println(this.fNom);
            if (this.fRepere != null) {
                pw.println(this.fRepere.getAxeH().getEtiquette() + ";" + this.fRepere.getAxeV().getEtiquette());
            } else {
                pw.println(";");
            }
            int nb = this.size();
            for (int i = 0; i < nb; ++i) {
                pw.println((this.getX(i) + ";" + this.getY(i)).replace('.', ','));
            }
            pw.flush();
            FileOutputStream fos = new FileOutputStream((String)pNomFic);
            FileChannel channelOut = fos.getChannel();
            CharsetEncoder encoder = StandardCharsets.ISO_8859_1.newEncoder();
            channelOut.write(encoder.encode(CharBuffer.wrap(sw.toString())));
            channelOut.close();
            fos.flush();
            fos.close();
            pw.close();
            return new File((String)pNomFic).getName();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public abstract void remove(int var1);

    public void addSerieListener(SerieListener l) {
        if (l != null && !this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeSerieListener(SerieListener l) {
        this.listeners.remove(l);
    }

    public void fireSerieRenamed() {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            this.listeners.get(i).serieRenamed(this);
        }
    }

    public void fireColorChanged() {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            this.listeners.get(i).serieColorChanged(this);
        }
    }

    public void fireVisibilityChanged() {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            this.listeners.get(i).serieVisibilityChanged(this);
        }
    }

    public abstract void clear();

    public double getXpourYMin() {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (this.getY(i) != this.yMin) continue;
            return this.getX(i);
        }
        return Double.NaN;
    }

    public boolean equals(Object pObj) {
        return pObj != null && pObj.getClass().equals(this.getClass()) && this.fNom.equals(((Serie)pObj).fNom);
    }

    @Override
    public Element getDomElement(Document pDoc) {
        Element root = pDoc.createElement(MapXmlGraph.getInstance().getNomElement(Serie.class));
        root.setAttribute(DOM_NOM, this.fNom);
        root.setAttribute(DOM_VISIBLE, String.valueOf(this.fVisible));
        root.appendChild(XmlUtils.createColorNode(pDoc, this.fCouleur));
        return root;
    }

    @Override
    public void setProperties(Node pNoeud) {
        this.setNom(XmlUtils.getAttributeStringValue(pNoeud, DOM_NOM, "?"));
        this.setVisible(XmlUtils.getAttributeBooleanValue(pNoeud, DOM_VISIBLE, true));
        this.setCouleur(XmlUtils.getColor(pNoeud));
    }

    public abstract int getIndice(Point var1);

    public abstract PointGraphique get(int var1);

    public Repere getRepere() {
        return this.fRepere;
    }

    void setRepere(Repere pRepere) {
        if (this.fRepere != null && pRepere != this.fRepere && this.fRepere.getDessin() != pRepere.getDessin()) {
            throw new IllegalArgumentException(Messages.getString("Serie.3"));
        }
        this.fRepere = pRepere;
    }

    public abstract double distance(Point var1);

    protected double hValToPix(double x) {
        return this.fRepere.fAxeH.valToPix(x);
    }

    protected double vValToPix(double x) {
        return this.fRepere.fAxeV.valToPix(x);
    }

    public Color getCouleur(int pIndiceValeur) {
        return this.getCouleur();
    }

    public boolean isVisible() {
        return this.fActive && this.fVisible;
    }

    public void setVisible(boolean etat) {
        if (etat != this.fVisible) {
            this.fVisible = etat;
            if (!this.fVisible && this.fRepere != null && this.fCursorable) {
                this.fRepere.getAxeH().getDessin().setCurseur(null, 0);
            }
            this.fireVisibilityChanged();
        }
    }

    public ConfigPlage getConfigPlage() {
        return this.fConfigPlage;
    }

    public void setConfigPlage(ConfigPlage pConfigPlage) {
        this.fConfigPlage = pConfigPlage;
    }

    public boolean isCursorable() {
        return this.fCursorable && this.fActive;
    }

    public void setCursorable(boolean pCursorable) {
        this.fCursorable = pCursorable;
    }

    public boolean isActive() {
        return this.fActive;
    }

    @Override
    public void setActive(boolean pActive) {
        this.fActive = pActive;
    }

    public boolean isVisibleInMenu() {
        return this.fVisibleInMenu;
    }

    public void setVisibleInMenu(boolean pVisibleInMenu) {
        this.fVisibleInMenu = pVisibleInMenu;
    }

    public String getOutpuLabel() {
        return this.fOutputLabel == null ? this.fNom : this.fOutputLabel;
    }

    public void setOutputLabel(String pOutputLabel) {
        this.fOutputLabel = pOutputLabel;
    }

    public abstract void dessineLegende(Graphics2D var1, int var2, int var3, int var4, int var5);

    public abstract Plage plageFor(double var1, double var3);

    public double getXMinAff() {
        return this.getXMin();
    }

    public double getXMaxAff() {
        return this.getXMax();
    }

    public boolean isHighlighted() {
        return this.fHighlighted;
    }

    public void setHighlighted(boolean pState) {
        this.fHighlighted = pState;
    }

    public String getNomLegende() {
        return this.getNom();
    }

    public boolean isNotEmpyOrNull(int iMin, int iMax) {
        if (this.size() == 0) {
            return false;
        }
        for (int i = iMin; i <= iMax; ++i) {
            double y = this.getY(i);
            if (Double.isNaN(y) || y == 0.0) continue;
            return true;
        }
        return false;
    }
}

