/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Axe;
import fr.dbe.graphique.FillVertical;
import fr.dbe.graphique.ITypeDessin;
import fr.dbe.graphique.MapXmlGraph;
import fr.dbe.graphique.Serie;
import fr.dbe.util.xml.XmlUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SeparateurVertical
implements ITypeDessin {
    private static final String DOM_FILL_VERTICAL = "fillVertical";
    private static final String DOM_Y_MIN = "yMin";
    private static final String DOM_Y_MAX = "yMax";
    private Color fFillColor;
    private Stroke fStroke = new BasicStroke(1.0f);
    private FillVertical fFillVertical;
    private Double fYMin;
    private Double fYMax;

    @Override
    public void dessine(Serie pCourbe, Graphics pG, double pXMin, double pXMax, int pPasAffichage) {
        if (this.fFillVertical != FillVertical.NONE) {
            this.fFillColor = this.fFillColor == null && pCourbe.getCouleur() == null ? new Color(0.0f, 0.0f, 0.0f, 0.0f) : new Color(pCourbe.getCouleur().getRed(), pCourbe.getCouleur().getGreen(), pCourbe.getCouleur().getBlue(), 10);
        }
        Axe axeH = pCourbe.getRepere().getAxeH();
        Axe axeV = pCourbe.getRepere().getAxeV();
        int x = (int)axeH.valToPix(pCourbe.getX(0));
        int y0 = this.fYMin == null ? (int)axeV.valToPix(axeV.getMin()) : (int)axeV.valToPix(this.fYMin);
        int y1 = this.fYMax == null ? (int)axeV.valToPix(axeV.getMax()) : (int)axeV.valToPix(this.fYMax);
        int height = Math.max(y0, y1) - Math.min(y0, y1);
        if (this.fFillVertical == FillVertical.LEFT) {
            int xMin = (int)axeH.valToPix(axeH.getMin());
            pG.setColor(this.fFillColor);
            pG.fillRect(xMin + 1, Math.min(y0, y1), x - xMin, height);
        } else if (this.fFillVertical == FillVertical.RIGHT) {
            int xMax = (int)axeH.valToPix(axeH.getMax());
            pG.setColor(this.fFillColor);
            pG.fillRect(x, Math.min(y0, y1), xMax - x + 1, height);
        }
        Stroke oldStroke = ((Graphics2D)pG).getStroke();
        ((Graphics2D)pG).setStroke(this.fStroke);
        pG.setColor(pCourbe.getCouleur());
        pG.drawLine(x, y0, x, y1);
        ((Graphics2D)pG).setStroke(oldStroke);
    }

    @Override
    public Color getFillColor() {
        return this.fFillColor;
    }

    @Override
    public void setFillColor(Color pFillColor) {
        this.fFillColor = pFillColor;
    }

    @Override
    public boolean hasFillColor() {
        return true;
    }

    @Override
    public Stroke getStroke() {
        return this.fStroke;
    }

    @Override
    public void setStroke(Stroke pStroke) {
        this.fStroke = pStroke == null ? new BasicStroke(1.0f) : pStroke;
    }

    public FillVertical getFillVertical() {
        return this.fFillVertical;
    }

    public void setFillVertical(FillVertical pFillVertical) {
        this.fFillVertical = pFillVertical;
    }

    public void setYMin(Double pYMin) {
        this.fYMin = Double.isFinite(pYMin) ? pYMin : null;
    }

    public void setYMax(Double pYMax) {
        this.fYMax = Double.isFinite(pYMax) ? pYMax : null;
    }

    @Override
    public Element getDomElement(Document pDoc) {
        Element root = pDoc.createElement(MapXmlGraph.getInstance().getNomElement(ITypeDessin.class));
        root.setAttribute(DOM_FILL_VERTICAL, String.valueOf((Object)this.fFillVertical));
        if (this.fYMin != null) {
            root.setAttribute(DOM_Y_MIN, String.valueOf(this.fYMin));
        }
        if (this.fYMax != null) {
            root.setAttribute(DOM_Y_MAX, String.valueOf(this.fYMax));
        }
        root.setAttribute(DOM_FILL_VERTICAL, String.valueOf((Object)this.fFillVertical));
        root.appendChild(XmlUtils.createStrokeNode(pDoc, (BasicStroke)this.fStroke));
        root.appendChild(XmlUtils.createColorNode(pDoc, this.fFillColor));
        return root;
    }

    @Override
    public void setProperties(Node pNoeud) {
        this.setFillVertical(FillVertical.valueOf(XmlUtils.getAttributeStringValue(pNoeud, DOM_FILL_VERTICAL, FillVertical.NONE.toString())));
        if (XmlUtils.attributeExists(pNoeud, DOM_Y_MIN)) {
            this.setYMin(XmlUtils.getAttributeDoubleValue(pNoeud, DOM_Y_MIN, Double.NaN));
        }
        if (XmlUtils.attributeExists(pNoeud, DOM_Y_MAX)) {
            this.setYMax(XmlUtils.getAttributeDoubleValue(pNoeud, DOM_Y_MAX, Double.NaN));
        }
        this.setStroke(XmlUtils.getStroke(pNoeud));
        this.setFillColor(XmlUtils.getColor(pNoeud));
    }

    @Override
    public int getDXMaxAff() {
        return 0;
    }

    @Override
    public int getDXMinAff() {
        return 0;
    }
}

