/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.CourbeRadar;
import fr.dbe.graphique.ITypeDessin;
import fr.dbe.graphique.Serie;
import fr.dbe.graphique.ToileRadar;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Radar
implements ITypeDessin {
    private final ToileRadar fToile;

    public Radar(ToileRadar pToile) {
        this.fToile = pToile;
    }

    @Override
    public void dessine(Serie pCourbe, Graphics g, double pXMin, double pXMax, int pPasAffichage) {
        if (!(pCourbe instanceof CourbeRadar)) {
            return;
        }
        CourbeRadar courbe = (CourbeRadar)pCourbe;
        double min = this.fToile.getYMin();
        double max = this.fToile.getYMax();
        double centerX = this.fToile.getCenterX();
        double centerY = this.fToile.getCenterY();
        double dr = this.fToile.getDr();
        Axis[] axis = this.fToile.getAxis();
        ((Graphics2D)g).setStroke(this.getStroke());
        g.setColor(courbe.getCouleur());
        courbe.clearPoints();
        for (int i = 0; i < courbe.size(); ++i) {
            double y = Math.max(min, Math.min(max, courbe.getY(i)));
            int xc = (int)(centerX + axis[i].dx * dr * y);
            int yc = (int)(centerY + axis[i].dy * dr * y);
            courbe.addPoint(xc, yc);
            if (Double.isNaN(y)) continue;
            g.fillOval(xc - 2, yc - 2, 5, 5);
            y = Math.max(min, Math.min(max, courbe.getY((i + 1) % courbe.size())));
            if (Double.isNaN(y)) continue;
            g.fillOval(xc - 2, yc - 2, 5, 5);
            g.drawLine(xc, yc, (int)(centerX + axis[(i + 1) % courbe.size()].dx * dr * y), (int)(centerY + axis[(i + 1) % courbe.size()].dy * dr * y));
        }
    }

    @Override
    public Stroke getStroke() {
        return new BasicStroke();
    }

    @Override
    public void setStroke(Stroke pStroke) {
    }

    @Override
    public boolean hasFillColor() {
        return false;
    }

    @Override
    public Color getFillColor() {
        return null;
    }

    @Override
    public void setFillColor(Color pCOlor) {
    }

    @Override
    public int getDXMinAff() {
        return 0;
    }

    @Override
    public int getDXMaxAff() {
        return 0;
    }

    @Override
    public Element getDomElement(Document doc) {
        return null;
    }

    @Override
    public void setProperties(Node pNoeud) {
    }

    public static class Axis {
        double alpha;
        double dx;
        double dy;
        String label;
        Rectangle labelRect;

        public Axis(double pAlpha, double pDx, double pDy, String pLabel, Rectangle pLabelRect) {
            this.alpha = pAlpha;
            this.dx = pDx;
            this.dy = pDy;
            this.label = pLabel;
            this.labelRect = pLabelRect;
        }
    }
}

