/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Axe;
import fr.dbe.graphique.Fond;
import fr.dbe.graphique.Repere;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;

public class PremiereBissectrice
extends Fond {
    public PremiereBissectrice(String pNom) {
        super(pNom);
        this.fFillColor = Color.gray;
        this.fColor = Color.gray;
    }

    @Override
    public void dessine(Graphics pG, Repere pRepere) {
        if (!this.fVisible) {
            return;
        }
        Axe axeH = pRepere.getAxeH();
        Axe axeV = pRepere.getAxeV();
        int xMin = (int)pRepere.getDrawingRectangle().getMinX();
        int xMax = (int)pRepere.getDrawingRectangle().getMaxX();
        GeneralPath polyline = new GeneralPath();
        Rectangle r = pG.getClipBounds();
        pG.setClip(r.intersection(pRepere.getDrawingRectangle()));
        pG.setColor(this.fColor);
        int ix = xMin;
        double x = axeH.pixToVal(ix);
        int iy = (int)axeV.valToPix(x);
        polyline.moveTo(axeH.pixToVal(ix), (double)iy);
        for (ix = xMin + 1; ix <= xMax; ++ix) {
            x = axeH.pixToVal(ix);
            iy = (int)axeV.valToPix(x);
            polyline.lineTo(ix, iy);
        }
        ((Graphics2D)pG).draw(polyline);
        pG.setClip(r);
    }

    @Override
    public double getYMax() {
        return -1.7976931348623157E308;
    }

    @Override
    public double getYMin() {
        return Double.MAX_VALUE;
    }

    @Override
    public void dessineLegende(Graphics2D pGraphics2d, int pWidth, int pHeight) {
        pGraphics2d.setColor(this.getColor());
        pGraphics2d.drawLine(0, pHeight / 2, pWidth, pHeight / 2);
    }
}

