/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Axe;
import fr.dbe.graphique.PointGraphique;
import fr.dbe.graphique.Repere;
import fr.dbe.util.commun.Utilitaire;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class PointCourbeRafale
extends PointGraphique {
    private final double[] fRafale;
    private final double fDx;

    public PointCourbeRafale(double pX, double[] pY, double pDx) {
        super(pX, pY[0]);
        this.fRafale = pY;
        this.fDx = pDx;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public void dessine(Graphics g, Repere pRepere) {
        g.setColor(this.fCouleur);
        Axe axeH = pRepere.getAxeH();
        Axe axeV = pRepere.getAxeV();
        double x0 = axeH.valToPix(this.getX());
        double y0 = axeV.valToPix(this.fRafale[0]);
        for (int k = 1; k < this.fRafale.length; ++k) {
            if (Double.isFinite(y0)) {
                g.drawLine((int)x0 - 2, (int)y0, (int)x0 + 2, (int)y0);
                g.drawLine((int)x0, (int)y0 - 2, (int)x0, (int)y0 + 2);
            }
            double x1 = axeH.valToPix(this.getX() + (double)k * this.fDx);
            double y1 = axeV.valToPix(this.fRafale[k]);
            g.drawLine((int)x0, (int)y0, (int)x1, (int)y1);
            x0 = x1;
            y0 = y1;
        }
        if (Double.isFinite(this.y)) {
            g.drawLine((int)x0 - 2, (int)y0, (int)x0 + 2, (int)y0);
            g.drawLine((int)x0, (int)y0 - 2, (int)x0, (int)y0 + 2);
        }
    }

    public double getYMin() {
        return Utilitaire.getMin(this.fRafale);
    }

    public double getYMax() {
        return Utilitaire.getMax(this.fRafale);
    }

    @Override
    public int getDiametre() {
        return 0;
    }

    @Override
    public void setDiametre(int pDiametre) {
    }

    @Override
    public void dessineLegende(Graphics2D pGraphics2d, int pX, int pY, int pWidth, int pHeight) {
        pGraphics2d.setColor(this.getCouleur());
        pGraphics2d.fillOval(pX - pHeight / 2, pY, pHeight, pHeight);
    }
}

