/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.PointGraphique;
import fr.dbe.graphique.Repere;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class PointCourbe
extends PointGraphique {
    private int fDiametre;

    public PointCourbe(double pX, double pY) {
        this(pX, pY, 1);
    }

    public PointCourbe(double pX, double pY, int pDiametre) {
        super(pX, pY);
        this.fDiametre = pDiametre;
    }

    public PointCourbe(double pX, double pY, int pDiametre, Color pColor) {
        super(pX, pY);
        this.fDiametre = pDiametre;
        this.setCouleur(pColor);
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public void dessine(Graphics g, Repere pRepere) {
        g.setColor(this.getCouleur());
        double yPix = pRepere.getAxeV().valToPix(this.y);
        if (Double.isFinite(yPix)) {
            g.fillOval((int)pRepere.getAxeH().valToPix(this.x) - this.fDiametre / 2, (int)yPix - this.fDiametre / 2, this.fDiametre - 1, this.fDiametre);
        }
    }

    @Override
    public int getDiametre() {
        return this.fDiametre;
    }

    @Override
    public void setDiametre(int pDiametre) {
        this.fDiametre = pDiametre;
    }

    @Override
    public void dessineLegende(Graphics2D pGraphics2d, int x, int pY, int pWidth, int pHeight) {
        pGraphics2d.setColor(this.getCouleur());
        pGraphics2d.fillOval(x - pHeight / 2, pY, pHeight, pHeight);
    }
}

