/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.JDessinGraphique;
import fr.dbe.graphique.LegendeWidget;
import fr.dbe.util.ihm.HorizontalLabelPosition;
import fr.dbe.util.ihm.Utils;
import fr.dbe.util.ihm.VerticalLabelPosition;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.BorderFactory;
import javax.swing.border.Border;

public class LabelWidget
extends LegendeWidget {
    public static final int NONE = 0;
    public static final int BOTTOM = 1;
    public static final int TOP = 2;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    private final String fText;
    private int fVerticalAnchor;
    private int fHorizontalAnchor;
    private int fPosX;

    public LabelWidget(JDessinGraphique pDessin, String pText, int pPosX, int pPosY) {
        super(pDessin);
        this.fPosX = pPosX;
        this.fPosY = pPosY;
        this.setCadre(false);
        this.setFont(new Font("Arial", 1, 11));
        this.fText = pText;
    }

    @Override
    public void dessine(Graphics pGraphics) {
        Graphics2D g = (Graphics2D)pGraphics;
        String title = this.fText;
        if (this.isVisible() && title != null && title.length() > 0) {
            g.setFont(this.getFont());
            FontMetrics fm = g.getFontMetrics();
            int w = fm.stringWidth(this.fText.replaceAll("<[^>]*>", "").replaceAll("</[^>]*>", ""));
            int h = fm.getHeight() + fm.getMaxAscent() + fm.getMaxDescent();
            int xLegende = Math.max(0, this.getDessin().getWidth() - w - this.fDxGauche);
            this.fDxGauche = this.getDessin().getWidth() - w - xLegende;
            if (this.getCouleurTexte() != null) {
                g.setColor(this.getCouleurTexte());
            }
            Color bg = null;
            if (this.getCouleurFond() != null) {
                bg = new Color(this.getCouleurFond().getRed(), this.getCouleurFond().getGreen(), this.getCouleurFond().getBlue(), (int)(this.getTransparence() * 255.0f));
            }
            switch (this.fVerticalAnchor) {
                case 1: {
                    this.fPosY = this.getDessin().getHeight() - h;
                    break;
                }
                case 2: {
                    this.fPosY = 0;
                }
            }
            switch (this.fHorizontalAnchor) {
                case 1: {
                    this.fPosX = 3;
                    break;
                }
                case 2: {
                    this.fPosX = this.getDessin().getWidth() - w - 3;
                }
            }
            Border border = null;
            if (this.isCadre() && this.getCouleurCadre() != null) {
                border = BorderFactory.createLineBorder(this.getCouleurCadre());
            }
            this.getRectangle().setBounds(Utils.drawLibelleHtml(g, this.fPosX, this.fPosY, title, HorizontalLabelPosition.LEFT, VerticalLabelPosition.TOP, bg, border));
            if (this.isSelected() && (this.fVerticalAnchor == 0 || this.fHorizontalAnchor == 0)) {
                int x = this.getRectangle().x;
                this.fPosY = this.getRectangle().y;
                w = this.getRectangle().width;
                h = this.getRectangle().height;
                g.setColor(Color.DARK_GRAY);
                g.fillRect(x - 2, this.fPosY - 2, 4, 4);
                g.fillRect(x - 2, this.fPosY - 2 + h, 4, 4);
                g.fillRect(x - 2 + w, this.fPosY - 2, 4, 4);
                g.fillRect(x - 2 + w, this.fPosY - 2 + h, 4, 4);
            }
        }
    }

    @Override
    public Dimension deplace(double pDx, double pDy) {
        if (this.fHorizontalAnchor == 0) {
            this.fPosX = (int)((double)this.fPosX + pDx);
        }
        if (this.fVerticalAnchor == 0) {
            this.fPosY = (int)((double)this.fPosY + pDy);
        }
        return new Dimension((int)pDx - this.fPosX, -((int)pDy - this.fPosY));
    }

    public void setVerticalAnchor(int pAnchor) {
        switch (pAnchor) {
            case 0: 
            case 1: 
            case 2: {
                this.fVerticalAnchor = pAnchor;
            }
        }
    }

    public void setHorizontalAnchor(int pAnchor) {
        switch (pAnchor) {
            case 0: 
            case 1: 
            case 2: {
                this.fHorizontalAnchor = pAnchor;
            }
        }
    }
}

