/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Axe;
import fr.dbe.graphique.AxeV;
import fr.dbe.graphique.Direction;
import fr.dbe.graphique.Graduation;
import fr.dbe.graphique.Marges;
import fr.dbe.graphique.PositionAxeH;
import fr.dbe.graphique.PositionAxeV;
import fr.dbe.graphique.PositionGraduation;
import fr.dbe.graphique.Sens;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

class GraduationV
extends Graduation {
    private Point fSelectedPoint;

    public GraduationV(AxeV pAxeV) {
        super(pAxeV);
        this.setMarges(new Marges(0.0, 3.0, 3.0, 3.0));
    }

    @Override
    protected Polygon dessineGraduation(Graphics pGraphics, int pPosition, String pTexte, Polygon[] pPolygons) {
        int positionAxe = this.getAxe().getPosition();
        Rectangle textbounds = pGraphics.getFontMetrics().getStringBounds(pTexte, pGraphics).getBounds();
        Polygon emprise = this.empriseGraduation(pGraphics, pPosition, pTexte);
        if (!this.intersects(emprise, pPolygons)) {
            pGraphics.setColor(this.getCouleur());
            pGraphics.drawLine(positionAxe - this.getTaille(), pPosition, positionAxe + this.getTaille(), pPosition);
            pGraphics.setColor(this.getCouleurTexte());
            int px = this.getAxe().getRepere().getPosAxeH() == PositionAxeH.ORIGINE && this.positionGraduation == PositionGraduation.NEAR_AXIS ? (int)this.getAxe().getRepere().getAxeH().valToPix(0.0) - textbounds.x - textbounds.width - this.getTaille() - 2 : (int)(emprise.getBounds2D().getMinX() + this.getMarges().getGauche());
            pGraphics.drawString(pTexte, px, (int)(emprise.getBounds2D().getMinY() - (double)textbounds.y + this.getMarges().getHaut()));
            return emprise;
        }
        return null;
    }

    @Override
    protected Polygon empriseGraduation(Graphics pGraphics, int pPosition, String pTexte) {
        int positionAxe = this.getAxe().getRepere().getPosAxeV() == PositionAxeV.ORIGINE ? (int)this.getAxe().getDessin().getMargesAxe().getGauche() : this.getAxe().getPosition();
        FontMetrics fm = pGraphics.getFontMetrics();
        Rectangle rect = null;
        Rectangle textBounds = fm.getStringBounds(pTexte, pGraphics).getBounds();
        textBounds.x = (int)((double)textBounds.x - this.getMarges().getGauche());
        textBounds.y = (int)((double)textBounds.y - this.getMarges().getHaut());
        textBounds.width = (int)((double)textBounds.width + (this.getMarges().getGauche() + this.getMarges().getDroite()));
        textBounds.y = (int)((double)textBounds.y - (this.getMarges().getHaut() + this.getMarges().getBas()));
        PositionAxeV cas = (PositionAxeV)this.getAxe().getRepere().getPosAxeV();
        if (cas == PositionAxeV.ORIGINE) {
            cas = positionAxe > this.getAxe().getDessin().getWidth() / 2 ? PositionAxeV.DROITE : PositionAxeV.GAUCHE;
        }
        switch (cas) {
            case GAUCHE: {
                int x = positionAxe - this.getTaille() - textBounds.width;
                int y = pPosition + textBounds.height / 2;
                rect = new Rectangle(x, y - textBounds.height, textBounds.width, textBounds.height);
                break;
            }
            case DROITE: {
                int x = positionAxe + this.getTaille() + 2;
                int y = pPosition + textBounds.height / 2;
                rect = new Rectangle(x, y - textBounds.height, textBounds.width, textBounds.height);
                break;
            }
        }
        return GraduationV.rectangleToPolygon(rect);
    }

    @Override
    public Direction getDirection() {
        return Direction.VERTICALE;
    }

    @Override
    public boolean contains(Point pPoint) {
        boolean res = this.containsFast(pPoint);
        if (res) {
            this.fSelectedPoint = pPoint;
        }
        return res;
    }

    @Override
    public boolean containsFast(Point pPoint) {
        return Math.abs(this.getAxe().getPosition() - pPoint.x) <= 3;
    }

    @Override
    public Dimension deplace(double pDx, double pDy) {
        if (!this.fDeplacable) {
            return new Dimension(0, 0);
        }
        this.fCurrentDrag.y = (int)((double)this.fCurrentDrag.y + pDy);
        double oldMax = this.getAxe().getMax();
        double oldMin = this.getAxe().getMin();
        if (this.fSelectedPoint != null) {
            double pc;
            Rectangle r = this.getAxe().getRepere().getDrawingRectangle();
            if (this.getAxe().getSens() == Sens.DIRECT) {
                if ((double)this.fCurrentDrag.y < r.getMaxY()) {
                    double base = this.getAxe().getRepere().getPosAxeH() == PositionAxeH.ORIGINE ? this.getAxe().valToPix(0.0) : (double)r.height + r.getMinY();
                    double pc2 = (this.getAxe().pixToVal((int)base) - this.getAxe().pixToVal(this.fCurrentDrag.y)) / (this.getAxe().pixToVal((int)base) - this.getAxe().pixToVal((int)((double)this.fCurrentDrag.y - pDy)));
                    if (Double.isFinite(pc2) && pc2 > 0.0) {
                        double max = (this.getAxe().getMax() - this.getAxe().getMin()) / pc2 + this.getAxe().getMin();
                        this.getAxe().getRepere().setBornesY(this.getAxe().getMin(), Math.max(this.getAxe().getMin(), max));
                    }
                }
            } else if ((double)this.fCurrentDrag.y > r.getMinY() && Double.isFinite(pc = ((double)this.fCurrentDrag.y - r.getMinY()) / ((double)this.fCurrentDrag.y - pDy - r.getMinY())) && pc > 0.0) {
                double max = (this.getAxe().getMax() - this.getAxe().getMin()) / pc + this.getAxe().getMin();
                this.getAxe().getRepere().setBornesY(this.getAxe().getMin(), Math.max(this.getAxe().getMin(), max));
            }
            if (this.getAxe().getRepere().getPosAxeH() == PositionAxeH.ORIGINE) {
                double c = (this.getAxe().getMax() - this.getAxe().getMin()) / (oldMax - oldMin);
                this.getAxe().getRepere().setBornesY(oldMin * c, oldMax * c);
            }
        }
        return new Dimension(0, (int)pDy);
    }

    @Override
    public void setDebutDrag(Point pPoint) {
        this.fCurrentDrag = pPoint;
    }

    @Override
    public double computeIntervalle(Axe pAxeV) {
        Rectangle r = pAxeV.getRepere().getDrawingRectangle();
        return Math.abs(pAxeV.pixToVal((int)r.getMinY()) - pAxeV.pixToVal((int)r.getMaxY())) / (double)this.getNombre();
    }
}

