/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Courbe;
import fr.dbe.graphique.PointCourbeRafale;
import fr.dbe.graphique.PointGraphique;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;

public class CourbeRafale
extends Courbe {
    private final List<PointCourbeRafale> fPoints = new ArrayList<PointCourbeRafale>();
    private final int fTailleMaxiRafale;
    private final Color[] fCouleurs;
    private int fIndiceCouleur = 0;

    public CourbeRafale(String nom, double pXMin, double pDx, int pTailleMaxiRafale, Color[] pCouleurs) {
        super(nom, pXMin, pDx);
        this.fTailleMaxiRafale = pTailleMaxiRafale;
        this.fCouleurs = pCouleurs;
    }

    public void setRafale(int indice, double[] pRafale) {
        PointCourbeRafale point = new PointCourbeRafale(this.getDx() * (double)indice + this.xMin, pRafale, this.getDx());
        point.setCouleur(this.fCouleurs[this.fIndiceCouleur++ % this.fCouleurs.length]);
        if (indice == 0) {
            this.yMin = Double.POSITIVE_INFINITY;
            this.yMax = Double.NEGATIVE_INFINITY;
        }
        if (indice == this.fY.size()) {
            this.fY.ajouter(point.getY());
            this.fPoints.add(point);
        } else if (indice > this.fY.size()) {
            for (int i = this.fY.size(); i < indice; ++i) {
                this.fY.ajouter(Double.NaN);
                this.fPoints.add(null);
            }
            this.fY.ajouter(point.getY());
        } else if (indice < this.fY.size()) {
            this.fY.set(indice, point.getY());
            this.fPoints.set(indice, point);
        }
        this.xMax = this.getDx() * (double)(this.fY.size() - 1) + this.xMin + (double)this.fTailleMaxiRafale;
        if (!Double.isNaN(point.getY())) {
            this.yMin = Math.min(this.yMin, point.getYMin());
            this.yMax = Math.max(this.yMax, point.getYMax());
        }
    }

    @Override
    public void dessine(Graphics g, double pXMin, double pXMax, int pPasAffichage) {
        if (!this.isVisible() || this.size() < 1 || this.fRepere == null) {
            return;
        }
        int i0 = Math.max(0, (int)((pXMin - this.getXMin()) / this.getDx()) - 1);
        int i1 = Math.min(this.size(), (int)((pXMax - this.getXMin()) / this.getDx()) + 2);
        for (int j = i0 + pPasAffichage; j < i1; j += pPasAffichage) {
            PointCourbeRafale pt = (PointCourbeRafale)this.get(j);
            pt.dessine(g, this.fRepere);
        }
    }

    @Override
    public PointGraphique get(int pIndice) {
        return this.fPoints.get(pIndice);
    }

    @Override
    public void removeFirst() {
        boolean kBornes = this.yMin == this.fY.get(0) || this.yMax == this.fY.get(0);
        this.fY.supprime(0);
        this.fPoints.remove(0);
        this.xMin += 1.0;
        this.xMax += 1.0;
        if (kBornes) {
            this.yMin = Double.POSITIVE_INFINITY;
            this.yMax = Double.NEGATIVE_INFINITY;
            for (PointCourbeRafale point : this.fPoints) {
                if (Double.isNaN(point.getY())) continue;
                this.yMin = Math.min(this.yMin, point.getYMin());
                this.yMax = Math.max(this.yMax, point.getYMax());
            }
        }
    }
}

