/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Axe;
import fr.dbe.graphique.Courbe;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;

public class CourbeMultiColor
extends Courbe {
    private List<Color> fColors = new ArrayList<Color>();

    public CourbeMultiColor(String pNom, double pXMin, double pDX) {
        super(pNom, pXMin, pDX);
    }

    public void setColors(List<Color> pColors) {
        this.fColors = pColors;
    }

    @Override
    public Color getCouleur(int pIndiceValeur) {
        return this.fColors.get(pIndiceValeur);
    }

    @Override
    public void dessine(Graphics g, double pXMin, double pXMax, int pPasAffichage) {
        if (!this.isVisible() || this.size() < 2 || this.fRepere == null) {
            return;
        }
        Axe axeH = this.fRepere.getAxeH();
        Axe axeV = this.fRepere.getAxeV();
        int i0 = Math.max(0, (int)((pXMin - this.getXMin()) / this.getDx()) - 1);
        int i1 = Math.min(this.size(), (int)((pXMax - this.getXMin()) / this.getDx()) + 2);
        int i = Math.max(0, (int)((pXMin - this.getXMin()) / this.getDx()));
        double x0 = axeH.valToPix(this.getX(i));
        double y0 = axeV.valToPix(this.getY(i));
        for (int j = i0 + pPasAffichage; j < i1; j += pPasAffichage) {
            double x = axeH.valToPix(this.getX(j));
            double y = axeV.valToPix(this.getY(j));
            if (Double.isFinite(y) && Double.isFinite(y0)) {
                g.setColor(this.fColors.get(j));
                g.drawLine((int)x0, (int)y0, (int)x, (int)y);
            }
            x0 = x;
            y0 = y;
        }
    }
}

